/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.Forest;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadialTreeLayout<V, E>
extends TreeLayout<V, E> {
    protected Map<V, PolarPoint> polarLocations;

    public RadialTreeLayout(Forest<V, E> g) {
        this(g, DEFAULT_DISTX, DEFAULT_DISTY);
    }

    public RadialTreeLayout(Forest<V, E> g, int distx) {
        this(g, distx, DEFAULT_DISTY);
    }

    public RadialTreeLayout(Forest<V, E> g, int distx, int disty) {
        super(g, distx, disty);
    }

    @Override
    protected void buildTree() {
        super.buildTree();
        this.polarLocations = new HashMap<V, PolarPoint>();
        this.setRadialLocations();
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
        this.buildTree();
    }

    @Override
    protected void setCurrentPositionFor(V vertex) {
        ((Point2D)this.locations.get(vertex)).setLocation(this.m_currentPoint);
    }

    @Override
    public void setLocation(V v, Point2D location) {
        Point2D c = this.getCenter();
        Point2D.Double pv = new Point2D.Double(location.getX() - c.getX(), location.getY() - c.getY());
        PolarPoint newLocation = PolarPoint.cartesianToPolar(pv);
        this.polarLocations.get(v).setLocation(newLocation);
    }

    public Map<V, PolarPoint> getPolarLocations() {
        return this.polarLocations;
    }

    @Override
    public Point2D transform(V v) {
        PolarPoint pp = this.polarLocations.get(v);
        double centerX = this.getSize().getWidth() / 2.0;
        double centerY = this.getSize().getHeight() / 2.0;
        Point2D cartesian = PolarPoint.polarToCartesian(pp);
        cartesian.setLocation(cartesian.getX() + centerX, cartesian.getY() + centerY);
        return cartesian;
    }

    private Point2D getMaxXY() {
        double maxx = 0.0;
        double maxy = 0.0;
        for (Point2D p : this.locations.values()) {
            maxx = Math.max(maxx, p.getX());
            maxy = Math.max(maxy, p.getY());
        }
        return new Point2D.Double(maxx, maxy);
    }

    private void setRadialLocations() {
        Point2D max = this.getMaxXY();
        double maxx = max.getX();
        double maxy = max.getY();
        maxx = Math.max(maxx, (double)this.size.width);
        double theta = Math.PI * 2 / maxx;
        double deltaRadius = (double)(this.size.width / 2) / maxy;
        for (Map.Entry entry : this.locations.entrySet()) {
            Object v = entry.getKey();
            Point2D p = (Point2D)entry.getValue();
            PolarPoint polarPoint = new PolarPoint(p.getX() * theta, (p.getY() - 50.0) * deltaRadius);
            this.polarLocations.put((PolarPoint)v, polarPoint);
        }
    }
}

