/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators;

import edu.uci.ics.jung.algorithms.generators.GraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lattice2DGenerator<V, E>
implements GraphGenerator<V, E> {
    protected int row_count;
    protected int col_count;
    protected boolean is_toroidal;
    protected Factory<Graph<V, E>> graph_factory;
    protected Factory<V> vertex_factory;
    protected Factory<E> edge_factory;
    private List<V> v_array;

    public Lattice2DGenerator(Factory<Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int latticeSize, boolean isToroidal) {
        this(graph_factory, vertex_factory, edge_factory, latticeSize, latticeSize, isToroidal);
    }

    public Lattice2DGenerator(Factory<Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int row_count, int col_count, boolean isToroidal) {
        if (row_count < 2 || col_count < 2) {
            throw new IllegalArgumentException("Row and column counts must each be at least 2.");
        }
        this.row_count = row_count;
        this.col_count = col_count;
        this.is_toroidal = isToroidal;
        this.graph_factory = graph_factory;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
    }

    public Graph<V, E> create() {
        int j;
        int i;
        int vertex_count = this.row_count * this.col_count;
        Graph graph = (Graph)this.graph_factory.create();
        this.v_array = new ArrayList<V>(vertex_count);
        for (int i2 = 0; i2 < vertex_count; ++i2) {
            Object v = this.vertex_factory.create();
            graph.addVertex(v);
            this.v_array.add(i2, v);
        }
        int start = this.is_toroidal ? 0 : 1;
        int end_row = this.is_toroidal ? this.row_count : this.row_count - 1;
        int end_col = this.is_toroidal ? this.col_count : this.col_count - 1;
        for (i = 0; i <= end_row; ++i) {
            for (j = 0; j < this.col_count; ++j) {
                graph.addEdge(this.edge_factory.create(), this.getVertex(i, j), this.getVertex(i + 1, j));
            }
        }
        for (i = 0; i <= this.row_count; ++i) {
            for (j = 0; j <= end_col; ++j) {
                graph.addEdge(this.edge_factory.create(), this.getVertex(i, j), this.getVertex(i, j + 1));
            }
        }
        if (graph.getDefaultEdgeType() == EdgeType.DIRECTED) {
            for (i = start; i < this.row_count; ++i) {
                for (j = 0; j < this.col_count; ++j) {
                    graph.addEdge(this.edge_factory.create(), this.getVertex(i, j), this.getVertex(i - 1, j));
                }
            }
            for (i = 0; i <= this.row_count; ++i) {
                for (j = start; j <= end_col; ++j) {
                    graph.addEdge(this.edge_factory.create(), this.getVertex(i, j), this.getVertex(i, j - 1));
                }
            }
        }
        return graph;
    }

    protected int getIndex(int i, int j) {
        return i % this.row_count * this.col_count + j % this.col_count;
    }

    protected V getVertex(int i, int j) {
        return this.v_array.get(this.getIndex(i, j));
    }

    protected V getVertex(int i) {
        return this.v_array.get(i);
    }

    protected int getRow(int i) {
        return i / this.row_count;
    }

    protected int getCol(int i) {
        return i % this.col_count;
    }
}

