/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.AbstractInputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class TeeInputStreamOutputStream
extends AbstractInputStreamWrapper {
    protected final boolean closeStreams;
    protected final boolean[] copyEnabled;
    private long destinationPosition = 0L;
    protected final OutputStream[] destinations;
    private long markPosition = 0L;
    private long readTime = 0L;
    private long sourcePosition = 0L;
    private final long[] writeTime;

    public TeeInputStreamOutputStream(InputStream source, boolean closeStreams, OutputStream ... destinations) {
        super(source);
        if (destinations == null) {
            throw new IllegalArgumentException("Destinations OutputStream can't be null");
        }
        if (destinations.length == 0) {
            throw new IllegalArgumentException("At least one destination OutputStream must be specified");
        }
        for (OutputStream destination : destinations) {
            if (destination != null) continue;
            throw new IllegalArgumentException("One of the outputstreams in the array is null");
        }
        this.writeTime = new long[destinations.length];
        this.destinations = destinations;
        this.closeStreams = closeStreams;
        this.copyEnabled = new boolean[destinations.length];
        Arrays.fill(this.copyEnabled, true);
    }

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination) {
        this(source, destination, true);
    }

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination, boolean closeStreams) {
        this(source, closeStreams, destination);
    }

    @Override
    public int available() throws IOException {
        return this.source.available();
    }

    @Override
    public void closeOnce() throws IOException {
        IOException e1 = null;
        try {
            byte[] buffer = new byte[8192];
            while (this.innerRead(buffer, 0, buffer.length) > 0) {
            }
        }
        catch (IOException e) {
            e1 = new IOException("Incomplete data was written to the destination OutputStream(s).");
            e1.initCause(e);
        }
        if (this.closeStreams) {
            long startr = System.currentTimeMillis();
            this.source.close();
            this.readTime += System.currentTimeMillis() - startr;
            int i = 0;
            while (i < this.destinations.length) {
                long start = System.currentTimeMillis();
                this.destinations[i].close();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
        if (e1 != null) {
            throw e1;
        }
    }

    public final void enableCopy(boolean enable) {
        Arrays.fill(this.copyEnabled, enable);
    }

    public final void enableCopy(boolean[] enable) {
        if (enable == null) {
            throw new IllegalArgumentException("Enable array can't be null");
        }
        if (enable.length != this.copyEnabled.length) {
            throw new IllegalArgumentException("Enable array must be of the same size of the OutputStream array passed in the constructor. Array size [" + enable.length + "] streams [" + this.copyEnabled.length + "]");
        }
        for (int i = 0; i < enable.length; ++i) {
            this.copyEnabled[i] = enable[i];
        }
    }

    public final OutputStream[] getDestinationStreams() {
        return this.destinations;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public long getWriteSize() {
        return this.destinationPosition;
    }

    public long[] getWriteTime() {
        return this.writeTime;
    }

    @Override
    public int innerRead(byte[] b, int off, int len) throws IOException {
        long startr = System.currentTimeMillis();
        int result = this.source.read(b, off, len);
        this.readTime += System.currentTimeMillis() - startr;
        if (result > 0) {
            if (this.sourcePosition + (long)result > this.destinationPosition) {
                int newLen = (int)(this.sourcePosition + (long)result - this.destinationPosition);
                int newOff = off + (result - newLen);
                for (int i = 0; i < this.destinations.length; ++i) {
                    if (!this.copyEnabled[i]) continue;
                    long start = System.currentTimeMillis();
                    this.destinations[i].write(b, newOff, newLen);
                    long[] lArray = this.getWriteTime();
                    int n = i;
                    lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
                }
                this.destinationPosition += (long)newLen;
            }
            this.sourcePosition += (long)result;
        }
        return result;
    }

    @Override
    public void mark(int readLimit) {
        this.source.mark(readLimit);
        this.markPosition = this.sourcePosition;
    }

    @Override
    public boolean markSupported() {
        return this.source.markSupported();
    }

    @Override
    public int read() throws IOException {
        long startr = System.currentTimeMillis();
        int result = this.source.read();
        this.readTime += System.currentTimeMillis() - startr;
        if (result >= 0) {
            ++this.sourcePosition;
            if (this.sourcePosition > this.destinationPosition) {
                for (int i = 0; i < this.destinations.length; ++i) {
                    if (!this.copyEnabled[i]) continue;
                    long start = System.currentTimeMillis();
                    this.destinations[i].write(result);
                    long[] lArray = this.getWriteTime();
                    int n = i;
                    lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
                }
                ++this.destinationPosition;
            }
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.source.reset();
        this.sourcePosition = this.markPosition;
    }
}

