/*
 * Decompiled with CFR 0.152.
 */
package com.cflex.util.lpSolve;

import com.cflex.util.lpSolve.LpConstant;
import com.cflex.util.lpSolve.LpMatrec;
import com.cflex.util.lpSolve.SolverListener;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringTokenizer;

public class LpModel
implements LpConstant {
    public SolverListener viewer;
    String lpName;
    public int verbose;
    int printDuals;
    int printSolution;
    public int debug;
    int printAtInvert;
    public int trace;
    int antiDegen;
    int doPresolve;
    int rows;
    int rowsAlloc;
    int columns;
    int columnsAlloc;
    int sum;
    int sumAlloc;
    int namesUsed;
    String[] rowName;
    String[] colName;
    int nonZeros;
    int matAlloc;
    LpMatrec[] mat;
    int[] colEnd;
    int[] colNo;
    int rowEndValid;
    int[] rowEnd;
    double[] origRh;
    double[] rh;
    double[] rhs;
    int[] mustBeInt;
    double[] origUpperBound;
    double[] origLowerBound;
    double[] upperBound;
    double[] lowerBound;
    int basisValid;
    int[] bas;
    int[] basis;
    int[] lower;
    int etaValid;
    int etaAlloc;
    int etaSize;
    int numInv;
    int maxNumInv;
    double[] etaValue;
    int[] etaRowNr;
    int[] etaColEnd;
    int bbRule;
    int breakAtInt;
    double breakValue;
    double objBound;
    int iter;
    int totalIter;
    int maxLevel;
    int totalNodes;
    double[] solution;
    double[] bestSolution;
    double[] duals;
    int maximise;
    int floorFirst;
    int[] changedSign;
    int scalingUsed;
    int columnsScaled;
    double[] scale;
    int nrLagrange;
    double[][] lagRow;
    double[] lagRhs;
    double[] lambda;
    int[] lagConType;
    double lagBound;
    int valid;
    double infinite;
    double epsilon;
    double epsb;
    double epsd;
    double epsel;
    HashMap rowNameHashtable;
    HashMap colNameHashtable;

    public LpModel(int n, int n2) throws Exception {
        int n3;
        if (n < 0 || n2 < 0) {
            throw new Exception("rows < 0 or columns < 0");
        }
        this.sum = n3 = n + n2;
        this.rows = n;
        this.columns = n2;
        this.lpName = "unnamed";
        this.verbose = 0;
        this.printDuals = 0;
        this.printSolution = 0;
        this.debug = 0;
        this.printAtInvert = 0;
        this.trace = 0;
        this.rowsAlloc = this.rows;
        this.columnsAlloc = this.columns;
        this.sumAlloc = n3;
        this.namesUsed = 0;
        this.objBound = 1.0E24;
        this.infinite = 1.0E24;
        this.epsilon = 0.001;
        this.epsb = 5.01E-7;
        this.epsd = 1.0E-6;
        this.epsel = 1.0E-8;
        this.nonZeros = 0;
        this.matAlloc = 1;
        this.mat = new LpMatrec[this.matAlloc];
        int n4 = 0;
        while (n4 < this.matAlloc) {
            this.mat[n4] = new LpMatrec(0, 0.0);
            ++n4;
        }
        this.colNo = new int[this.matAlloc];
        Arrays.fill(this.colNo, 0);
        this.colEnd = new int[this.columns + 1];
        Arrays.fill(this.colEnd, 0);
        this.rowEnd = new int[this.rows + 1];
        Arrays.fill(this.rowEnd, 0);
        this.rowEndValid = 0;
        this.origRh = new double[this.rows + 1];
        Arrays.fill(this.origRh, 0.0);
        this.rh = new double[this.rows + 1];
        Arrays.fill(this.rh, 0.0);
        this.rhs = new double[this.rows + 1];
        Arrays.fill(this.rhs, 0.0);
        this.mustBeInt = new int[n3 + 1];
        Arrays.fill(this.mustBeInt, 0);
        this.origUpperBound = new double[n3 + 1];
        Arrays.fill(this.origUpperBound, this.infinite);
        this.upperBound = new double[n3 + 1];
        Arrays.fill(this.upperBound, 0.0);
        this.origLowerBound = new double[n3 + 1];
        Arrays.fill(this.origLowerBound, 0.0);
        this.lowerBound = new double[n3 + 1];
        Arrays.fill(this.lowerBound, 0.0);
        this.basisValid = 1;
        this.bas = new int[this.rows + 1];
        this.basis = new int[n3 + 1];
        this.lower = new int[n3 + 1];
        n4 = 0;
        while (n4 <= this.rows) {
            this.bas[n4] = n4;
            this.basis[n4] = 1;
            ++n4;
        }
        n4 = this.rows + 1;
        while (n4 <= n3) {
            this.basis[n4] = 0;
            ++n4;
        }
        n4 = 0;
        while (n4 <= n3) {
            this.lower[n4] = 1;
            ++n4;
        }
        this.etaValid = 1;
        this.etaSize = 0;
        this.etaAlloc = 10000;
        this.maxNumInv = 50;
        this.nrLagrange = 0;
        this.etaValue = new double[this.etaAlloc];
        Arrays.fill(this.etaValue, 0.0);
        this.etaRowNr = new int[this.etaAlloc];
        Arrays.fill(this.etaRowNr, 0);
        this.etaColEnd = new int[this.rowsAlloc + this.maxNumInv + 1];
        Arrays.fill(this.etaColEnd, 0);
        this.bbRule = 0;
        this.breakAtInt = 0;
        this.breakValue = 0.0;
        this.iter = 0;
        this.totalIter = 0;
        this.solution = new double[n3 + 1];
        Arrays.fill(this.solution, 0.0);
        this.bestSolution = new double[n3 + 1];
        Arrays.fill(this.bestSolution, 0.0);
        this.duals = new double[this.rows + 1];
        Arrays.fill(this.duals, 0.0);
        this.maximise = 0;
        this.floorFirst = 1;
        this.scalingUsed = 0;
        this.columnsScaled = 0;
        this.changedSign = new int[this.rows + 1];
        Arrays.fill(this.changedSign, 0);
        this.valid = 0;
        this.rowNameHashtable = new HashMap(10007);
        this.colNameHashtable = new HashMap(10007);
    }

    public LpModel(LpModel lpModel) throws Exception {
        int n = this.rowsAlloc + 1;
        int n2 = this.columnsAlloc + 1;
        int n3 = this.sumAlloc + 1;
        this.sum = this.sum;
        this.rows = this.rows;
        this.columns = this.columns;
        this.lpName = this.lpName;
        this.verbose = this.verbose;
        this.printDuals = this.printDuals;
        this.printSolution = this.printSolution;
        this.debug = this.debug;
        this.printAtInvert = this.printAtInvert;
        this.trace = this.trace;
        this.rowsAlloc = this.rowsAlloc;
        this.columnsAlloc = this.columnsAlloc;
        this.sumAlloc = this.sumAlloc;
        this.namesUsed = this.namesUsed;
        this.objBound = this.objBound;
        this.infinite = this.infinite;
        this.epsilon = this.epsilon;
        this.epsb = this.epsb;
        this.epsd = this.epsd;
        this.epsel = this.epsel;
        this.nonZeros = this.nonZeros;
        this.matAlloc = this.matAlloc;
        this.rowEndValid = this.rowEndValid;
        this.basisValid = this.basisValid;
        this.etaValid = this.etaValid;
        this.etaSize = this.etaSize;
        this.etaAlloc = this.etaAlloc;
        this.maxNumInv = this.maxNumInv;
        this.nrLagrange = this.nrLagrange;
        this.bbRule = this.bbRule;
        this.breakAtInt = this.breakAtInt;
        this.breakValue = this.breakValue;
        this.iter = this.iter;
        this.totalIter = this.totalIter;
        this.maximise = this.maximise;
        this.floorFirst = this.floorFirst;
        this.scalingUsed = this.scalingUsed;
        this.columnsScaled = this.columnsScaled;
        this.valid = this.valid;
        if (this.namesUsed == 1) {
            this.colName = new String[n2];
            System.arraycopy(this.colName, 0, this.colName, 0, this.colName.length);
            this.rowName = new String[n];
            System.arraycopy(this.rowName, 0, this.rowName, 0, this.rowName.length);
        }
        this.rowNameHashtable = (HashMap)this.rowNameHashtable.clone();
        this.colNameHashtable = (HashMap)this.colNameHashtable.clone();
        this.mat = new LpMatrec[this.matAlloc];
        System.arraycopy(this.mat, 0, this.mat, 0, this.mat.length);
        this.colEnd = new int[n2];
        System.arraycopy(this.colEnd, 0, this.colEnd, 0, this.colEnd.length);
        this.rowEnd = new int[n];
        System.arraycopy(this.rowEnd, 0, this.rowEnd, 0, this.rowEnd.length);
        this.origRh = new double[n];
        System.arraycopy(this.origRh, 0, this.origRh, 0, this.origRh.length);
        this.rh = new double[n];
        System.arraycopy(this.rh, 0, this.rh, 0, this.rh.length);
        this.rhs = new double[n];
        System.arraycopy(this.rhs, 0, this.rhs, 0, this.rhs.length);
        this.mustBeInt = new int[n3];
        System.arraycopy(this.mustBeInt, 0, this.mustBeInt, 0, this.mustBeInt.length);
        this.origUpperBound = new double[n3];
        System.arraycopy(this.origUpperBound, 0, this.origUpperBound, 0, this.origUpperBound.length);
        this.origLowerBound = new double[n3];
        System.arraycopy(this.origLowerBound, 0, this.origLowerBound, 0, this.origLowerBound.length);
        this.upperBound = new double[n3];
        System.arraycopy(this.upperBound, 0, this.upperBound, 0, this.upperBound.length);
        this.lowerBound = new double[n3];
        System.arraycopy(this.lowerBound, 0, this.lowerBound, 0, this.lowerBound.length);
        this.bas = new int[n];
        System.arraycopy(this.bas, 0, this.bas, 0, this.bas.length);
        this.basis = new int[n3];
        System.arraycopy(this.basis, 0, this.basis, 0, this.basis.length);
        this.lower = new int[n3];
        System.arraycopy(this.lower, 0, this.lower, 0, this.lower.length);
        this.etaValue = new double[this.etaAlloc];
        System.arraycopy(this.etaValue, 0, this.etaValue, 0, this.etaValue.length);
        this.etaRowNr = new int[this.etaAlloc];
        System.arraycopy(this.etaRowNr, 0, this.etaRowNr, 0, this.etaRowNr.length);
        this.solution = new double[n3];
        System.arraycopy(this.solution, 0, this.solution, 0, this.solution.length);
        this.bestSolution = new double[n3];
        System.arraycopy(this.bestSolution, 0, this.bestSolution, 0, this.bestSolution.length);
        this.duals = new double[n];
        System.arraycopy(this.duals, 0, this.duals, 0, this.duals.length);
        this.changedSign = new int[n];
        System.arraycopy(this.changedSign, 0, this.changedSign, 0, this.changedSign.length);
        this.colNo = new int[this.matAlloc + 1];
        System.arraycopy(this.colNo, 0, this.colNo, 0, this.colNo.length);
        this.etaColEnd = new int[this.rowsAlloc + this.maxNumInv + 1];
        System.arraycopy(this.etaColEnd, 0, this.etaColEnd, 0, this.etaColEnd.length);
        if (this.scalingUsed == 1) {
            this.scale = new double[n3];
            System.arraycopy(this.scale, 0, this.scale, 0, this.scale.length);
        }
        if (this.nrLagrange > 0) {
            this.lagRhs = new double[this.nrLagrange];
            System.arraycopy(this.lagRhs, 0, this.lagRhs, 0, this.lagRhs.length);
            this.lambda = new double[this.nrLagrange];
            System.arraycopy(this.lambda, 0, this.lambda, 0, this.lambda.length);
            this.lagConType = new int[this.nrLagrange];
            System.arraycopy(this.lagConType, 0, this.lagConType, 0, this.lagConType.length);
            this.lagRow = new double[this.nrLagrange][n2];
            int n4 = 0;
            while (n4 < this.nrLagrange) {
                System.arraycopy(this.lagRow[n4], 0, this.lagRow[n4], 0, this.lagRow[n4].length);
                ++n4;
            }
        }
    }

    public void incrementMatrixSpace(int n) throws Exception {
        if (this.nonZeros + n >= this.matAlloc) {
            if (this.matAlloc < 10000) {
                this.matAlloc = 10000;
            }
            while (this.nonZeros + n >= this.matAlloc) {
                this.matAlloc = (int)((double)this.matAlloc * 1.5);
            }
            LpMatrec[] lpMatrecArray = this.mat;
            this.mat = new LpMatrec[this.matAlloc];
            System.arraycopy(lpMatrecArray, 0, this.mat, 0, lpMatrecArray.length);
            int[] nArray = this.colNo;
            this.colNo = new int[this.matAlloc + 1];
            System.arraycopy(nArray, 0, this.colNo, 0, nArray.length);
        }
    }

    public void incrementRowSpace() throws Exception {
        if (this.rows > this.rowsAlloc) {
            this.rowsAlloc = this.rows + 10;
            this.sumAlloc = this.rowsAlloc + this.columnsAlloc;
            double[] dArray = this.origRh;
            this.origRh = new double[this.rowsAlloc + 1];
            System.arraycopy(dArray, 0, this.origRh, 0, dArray.length);
            dArray = this.rh;
            this.rh = new double[this.rowsAlloc + 1];
            System.arraycopy(dArray, 0, this.rh, 0, dArray.length);
            dArray = this.rhs;
            this.rhs = new double[this.rowsAlloc + 1];
            System.arraycopy(dArray, 0, this.rhs, 0, dArray.length);
            dArray = this.origUpperBound;
            this.origUpperBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.origUpperBound, 0, dArray.length);
            dArray = this.upperBound;
            this.upperBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.upperBound, 0, dArray.length);
            dArray = this.origLowerBound;
            this.origLowerBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.origLowerBound, 0, dArray.length);
            dArray = this.lowerBound;
            this.lowerBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.lowerBound, 0, dArray.length);
            dArray = this.solution;
            this.solution = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.solution, 0, dArray.length);
            dArray = this.bestSolution;
            this.bestSolution = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.bestSolution, 0, dArray.length);
            int[] nArray = this.rowEnd;
            this.rowEnd = new int[this.rowsAlloc + 1];
            System.arraycopy(nArray, 0, this.rowEnd, 0, nArray.length);
            nArray = this.basis;
            this.basis = new int[this.sumAlloc + 1];
            System.arraycopy(nArray, 0, this.basis, 0, nArray.length);
            nArray = this.lower;
            this.lower = new int[this.sumAlloc + 1];
            System.arraycopy(nArray, 0, this.lower, 0, nArray.length);
            nArray = this.mustBeInt;
            this.mustBeInt = new int[this.sumAlloc + 1];
            System.arraycopy(nArray, 0, this.mustBeInt, 0, nArray.length);
            nArray = this.bas;
            this.bas = new int[this.rowsAlloc + 1];
            System.arraycopy(nArray, 0, this.bas, 0, nArray.length);
            dArray = this.duals;
            this.duals = new double[this.rowsAlloc + 1];
            System.arraycopy(dArray, 0, this.duals, 0, dArray.length);
            nArray = this.changedSign;
            this.changedSign = new int[this.rowsAlloc + 1];
            System.arraycopy(nArray, 0, this.changedSign, 0, nArray.length);
            nArray = this.etaColEnd;
            this.etaColEnd = new int[this.rowsAlloc + this.maxNumInv + 1];
            System.arraycopy(nArray, 0, this.etaColEnd, 0, nArray.length);
            if (this.namesUsed != 0) {
                String[] stringArray = this.rowName;
                this.rowName = new String[this.rowsAlloc + 1];
                System.arraycopy(stringArray, 0, this.rowName, 0, stringArray.length);
            }
            if (this.scalingUsed != 0) {
                dArray = this.scale;
                this.scale = new double[this.sumAlloc + 1];
                System.arraycopy(dArray, 0, this.scale, 0, dArray.length);
            }
        }
    }

    public void incrementColumnSpace() throws Exception {
        if (this.columns >= this.columnsAlloc) {
            this.columnsAlloc = this.columns + 10;
            this.sumAlloc = this.rowsAlloc + this.columnsAlloc;
            int[] nArray = this.mustBeInt;
            this.mustBeInt = new int[this.sumAlloc + 1];
            System.arraycopy(nArray, 0, this.mustBeInt, 0, nArray.length);
            double[] dArray = this.origUpperBound;
            this.origUpperBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.origUpperBound, 0, dArray.length);
            dArray = this.upperBound;
            this.upperBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.upperBound, 0, dArray.length);
            dArray = this.origLowerBound;
            this.origLowerBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.origLowerBound, 0, dArray.length);
            dArray = this.lowerBound;
            this.lowerBound = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.lowerBound, 0, dArray.length);
            dArray = this.solution;
            this.solution = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.solution, 0, dArray.length);
            dArray = this.bestSolution;
            this.bestSolution = new double[this.sumAlloc + 1];
            System.arraycopy(dArray, 0, this.bestSolution, 0, dArray.length);
            nArray = this.basis;
            this.basis = new int[this.sumAlloc + 1];
            System.arraycopy(nArray, 0, this.basis, 0, nArray.length);
            nArray = this.lower;
            this.lower = new int[this.sumAlloc + 1];
            System.arraycopy(nArray, 0, this.lower, 0, nArray.length);
            if (this.namesUsed != 0) {
                String[] stringArray = this.colName;
                this.colName = new String[this.columnsAlloc + 1];
                System.arraycopy(stringArray, 0, this.colName, 0, stringArray.length);
            }
            if (this.scalingUsed != 0) {
                dArray = this.scale;
                this.scale = new double[this.sumAlloc + 1];
                System.arraycopy(dArray, 0, this.scale, 0, dArray.length);
            }
            int[] nArray2 = this.colEnd;
            this.colEnd = new int[this.columnsAlloc + 1];
            System.arraycopy(nArray2, 0, this.colEnd, 0, nArray2.length);
        }
    }

    public void setMatrixElement(int n, int n2, double d) throws Exception {
        if (n > this.rows || n < 0) {
            throw new Exception("Row out of range");
        }
        if (n2 > this.columns || n2 < 1) {
            throw new Exception("Column out of range");
        }
        if (this.scalingUsed != 0) {
            d *= this.scale[n] * this.scale[this.rows + n2];
        }
        if (this.basis[n2] == 1 && n > 0) {
            this.basisValid = 0;
        }
        this.etaValid = 0;
        int n3 = this.colEnd[n2 - 1];
        while (n3 < this.colEnd[n2] && this.mat[n3].rowNr != n) {
            ++n3;
        }
        if (n3 != this.colEnd[n2] && this.mat[n3].rowNr == n) {
            if (Math.abs(d) > this.epsilon) {
                this.mat[n3].value = this.scalingUsed != 0 ? (this.changedSign[n] != 0 ? -d * this.scale[n] * this.scale[n2] : d * this.scale[n] * this.scale[n2]) : (this.changedSign[n] != 0 ? -d : d);
            } else {
                int n4 = this.nonZeros;
                int n5 = n3;
                while (n5 < n4) {
                    this.mat[n5] = this.mat[n5 + 1];
                    ++n5;
                }
                n5 = n2;
                while (n5 <= this.columns) {
                    int n6 = n5++;
                    this.colEnd[n6] = this.colEnd[n6] - 1;
                }
                --this.nonZeros;
            }
        } else if (Math.abs(d) > this.epsilon) {
            int n7;
            this.incrementMatrixSpace(1);
            int n8 = n7 = this.nonZeros;
            while (n8 > n3) {
                this.mat[n8] = this.mat[n8 - 1];
                --n8;
            }
            n8 = n2;
            while (n8 <= this.columns) {
                int n9 = n8++;
                this.colEnd[n9] = this.colEnd[n9] + 1;
            }
            if (this.mat[n3] == null) {
                this.mat[n3] = new LpMatrec(0, 0.0);
            }
            this.mat[n3].rowNr = n;
            this.mat[n3].value = this.scalingUsed != 0 ? (this.changedSign[n] != 0 ? -d * this.scale[n] * this.scale[n2] : d * this.scale[n] * this.scale[n2]) : (this.changedSign[n] != 0 ? -d : d);
            this.rowEndValid = 0;
            ++this.nonZeros;
        }
    }

    public void setObjFn(double[] dArray) throws Exception {
        int n = 1;
        while (n <= this.columns) {
            this.setMatrixElement(0, n, dArray[n]);
            ++n;
        }
    }

    public void strSetObjFn(String string) throws Exception {
        double[] dArray = new double[this.columns + 1];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < this.columns) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        if (n < this.columns) {
            throw new Exception("Not enough numbers in the string in str_set_obj_fn");
        }
        this.setObjFn(dArray);
    }

    public void addConstraint(double[] dArray, int n, double d) throws Exception {
        int[] nArray = new int[this.columns + 1];
        int n2 = 1;
        while (n2 <= this.columns) {
            if (dArray[n2] != 0.0) {
                nArray[n2] = 1;
                ++this.nonZeros;
            } else {
                nArray[n2] = 0;
            }
            ++n2;
        }
        LpMatrec[] lpMatrecArray = new LpMatrec[this.nonZeros];
        n2 = 0;
        while (n2 < lpMatrecArray.length) {
            lpMatrecArray[n2] = new LpMatrec(0, 0.0);
            ++n2;
        }
        this.incrementMatrixSpace(0);
        ++this.rows;
        ++this.sum;
        this.incrementRowSpace();
        if (this.scalingUsed != 0) {
            n2 = this.sum;
            while (n2 > this.rows) {
                this.scale[n2] = this.scale[n2 - 1];
                --n2;
            }
            this.scale[this.rows] = 1.0;
        }
        if (this.namesUsed != 0) {
            this.rowName[this.rows] = new String("r_" + this.rows);
        }
        if (this.scalingUsed != 0 && this.columnsScaled != 0) {
            n2 = 1;
            while (n2 <= this.columns) {
                int n3 = n2;
                dArray[n3] = dArray[n3] * this.scale[this.rows + n2];
                ++n2;
            }
        }
        this.changedSign[this.rows] = n == 2 ? 1 : 0;
        int n4 = 0;
        int n5 = 0;
        n2 = 1;
        while (n2 <= this.columns) {
            int n6 = n5;
            while (n6 < this.colEnd[n2]) {
                lpMatrecArray[n4].rowNr = this.mat[n6].rowNr;
                lpMatrecArray[n4].value = this.mat[n6].value;
                ++n4;
                ++n6;
            }
            if (nArray[n2] != 0) {
                lpMatrecArray[n4].value = this.changedSign[this.rows] != 0 ? -dArray[n2] : dArray[n2];
                lpMatrecArray[n4].rowNr = this.rows;
            }
            n5 = this.colEnd[n2];
            this.colEnd[n2] = ++n4;
            ++n2;
        }
        System.arraycopy(lpMatrecArray, 0, this.mat, 0, lpMatrecArray.length);
        n2 = this.sum;
        while (n2 > this.rows) {
            this.origUpperBound[n2] = this.origUpperBound[n2 - 1];
            this.origLowerBound[n2] = this.origLowerBound[n2 - 1];
            this.basis[n2] = this.basis[n2 - 1];
            this.lower[n2] = this.lower[n2 - 1];
            this.mustBeInt[n2] = this.mustBeInt[n2 - 1];
            --n2;
        }
        n2 = 1;
        while (n2 <= this.rows) {
            if (this.bas[n2] >= this.rows) {
                int n7 = n2;
                this.bas[n7] = this.bas[n7] + 1;
            }
            ++n2;
        }
        if (n == 0 || n == 2) {
            this.origUpperBound[this.rows] = this.infinite;
        } else if (n == 1) {
            this.origUpperBound[this.rows] = 0.0;
        } else {
            throw new Exception("Wrong constraint type\n");
        }
        this.origLowerBound[this.rows] = 0.0;
        this.origRh[this.rows] = n == 2 && d != 0.0 ? -d : d;
        this.rowEndValid = 0;
        this.bas[this.rows] = this.rows;
        this.basis[this.rows] = 1;
        this.lower[this.rows] = 1;
        this.etaValid = 0;
    }

    public void strAddConstraint(String string, int n, double d) throws Exception {
        int n2 = 0;
        double[] dArray = new double[this.columns + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n2 < this.columns) {
            dArray[++n2] = Double.valueOf(stringTokenizer.nextToken());
        }
        this.addConstraint(dArray, n, d);
    }

    public void delConstraint(int n) throws Exception {
        if (n < 1 || n > this.rows) {
            throw new Exception("There is no constraint nr. " + n);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 <= this.columns) {
            int n5 = n3;
            while (n5 < this.colEnd[n4]) {
                if (this.mat[n5].rowNr != n) {
                    this.mat[n2] = this.mat[n5];
                    if (this.mat[n2].rowNr > n) {
                        --this.mat[n2].rowNr;
                    }
                    ++n2;
                } else {
                    --this.nonZeros;
                }
                ++n5;
            }
            n3 = this.colEnd[n4];
            this.colEnd[n4] = n2;
            ++n4;
        }
        n4 = n;
        while (n4 < this.rows) {
            this.origRh[n4] = this.origRh[n4 + 1];
            this.changedSign[n4] = this.changedSign[n4 + 1];
            this.bas[n4] = this.bas[n4 + 1];
            if (this.namesUsed != 0) {
                this.rowName[n4] = this.rowName[n4 + 1];
            }
            ++n4;
        }
        n4 = 1;
        while (n4 < this.rows) {
            if (this.bas[n4] > n) {
                int n6 = n4;
                this.bas[n6] = this.bas[n6] - 1;
            }
            ++n4;
        }
        n4 = n;
        while (n4 < this.sum) {
            this.lower[n4] = this.lower[n4 + 1];
            this.basis[n4] = this.basis[n4 + 1];
            this.origUpperBound[n4] = this.origUpperBound[n4 + 1];
            this.origLowerBound[n4] = this.origLowerBound[n4 + 1];
            this.mustBeInt[n4] = this.mustBeInt[n4 + 1];
            if (this.scalingUsed != 0) {
                this.scale[n4] = this.scale[n4 + 1];
            }
            ++n4;
        }
        --this.rows;
        --this.sum;
        this.rowEndValid = 0;
        this.etaValid = 0;
        this.basisValid = 0;
    }

    public void addLagCon(double[] dArray, int n, double d) throws Exception {
        int n2;
        double d2 = 0.0;
        if (n == 0 || n == 1) {
            d2 = 1.0;
        } else if (n == 2) {
            d2 = -1.0;
        } else {
            throw new Exception("con_type not implemented\n");
        }
        ++this.nrLagrange;
        if (this.nrLagrange == 1) {
            this.lagRow = new double[this.nrLagrange][];
            this.lagRhs = new double[this.nrLagrange];
            this.lambda = new double[this.nrLagrange];
            this.lagConType = new int[this.nrLagrange];
            n2 = 0;
            while (n2 < this.nrLagrange) {
                this.lagRhs[n2] = 0.0;
                this.lambda[n2] = 0.0;
                this.lagConType[n2] = 0;
                ++n2;
            }
        } else {
            double[][] dArray2 = this.lagRow;
            this.lagRow = new double[this.nrLagrange][];
            System.arraycopy(dArray2, 0, this.lagRow, 0, dArray2.length);
            double[] dArray3 = this.lagRhs;
            this.lagRhs = new double[this.nrLagrange];
            System.arraycopy(dArray3, 0, this.lagRhs, 0, dArray3.length);
            dArray3 = this.lambda;
            this.lambda = new double[this.nrLagrange];
            System.arraycopy(dArray3, 0, this.lambda, 0, dArray3.length);
            int[] nArray = this.lagConType;
            this.lagConType = new int[this.nrLagrange];
            System.arraycopy(nArray, 0, this.lagConType, 0, nArray.length);
        }
        this.lagRow[this.nrLagrange - 1] = new double[this.columns + 1];
        this.lagRhs[this.nrLagrange - 1] = d * d2;
        n2 = 1;
        while (n2 <= this.columns) {
            this.lagRow[this.nrLagrange - 1][n2] = dArray[n2] * d2;
            ++n2;
        }
        this.lambda[this.nrLagrange - 1] = 0.0;
        this.lagConType[this.nrLagrange - 1] = n == 1 ? 1 : 0;
    }

    public void strAddLagCon(String string, int n, double d) throws Exception {
        int n2 = 0;
        double[] dArray = new double[this.columns + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n2 < this.columns) {
            dArray[++n2] = Double.valueOf(stringTokenizer.nextToken());
        }
        if (n2 < this.columns) {
            throw new Exception("not enough value for str_add_lag_con");
        }
        this.addLagCon(dArray, n, d);
    }

    public void addColumn(double[] dArray) throws Exception {
        int n;
        ++this.columns;
        ++this.sum;
        this.incrementColumnSpace();
        this.incrementMatrixSpace(this.rows + 1);
        if (this.scalingUsed != 0) {
            n = 0;
            while (n <= this.rows) {
                int n2 = n;
                dArray[n2] = dArray[n2] * this.scale[n];
                ++n;
            }
            this.scale[this.sum] = 1.0;
        }
        int n3 = this.colEnd[this.columns - 1];
        n = 0;
        while (n <= this.rows) {
            if (dArray[n] != 0.0) {
                this.mat[n3].rowNr = n;
                this.mat[n3].value = this.changedSign[n] != 0 ? -dArray[n] : dArray[n];
                ++this.nonZeros;
                ++n3;
            }
            ++n;
        }
        this.colEnd[this.columns] = n3;
        this.origLowerBound[this.sum] = 0.0;
        this.origUpperBound[this.sum] = this.infinite;
        this.lower[this.sum] = 1;
        this.basis[this.sum] = 0;
        this.mustBeInt[this.sum] = 0;
        if (this.namesUsed != 0) {
            this.colName[this.columns] = new String("var_" + this.columns);
        }
        this.rowEndValid = 0;
    }

    public void strAddColumn(String string) throws Exception {
        int n = 0;
        double[] dArray = new double[this.rows + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < this.rows) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        if (n < this.rows) {
            throw new Exception("Bad String in str_add_column: " + string);
        }
        this.addColumn(dArray);
    }

    public void deleteColumn(int n) throws Exception {
        if (n > this.columns || n < 1) {
            throw new Exception("Column out of range in del_column");
        }
        int n2 = 1;
        while (n2 <= this.rows) {
            if (this.bas[n2] == this.rows + n) {
                this.basisValid = 0;
            } else if (this.bas[n2] > this.rows + n) {
                int n3 = n2;
                this.bas[n3] = this.bas[n3] - 1;
            }
            ++n2;
        }
        n2 = this.rows + n;
        while (n2 < this.sum) {
            if (this.namesUsed != 0) {
                this.colName[n2 - this.rows] = this.colName[n2 - this.rows + 1];
            }
            this.mustBeInt[n2] = this.mustBeInt[n2 + 1];
            this.origUpperBound[n2] = this.origUpperBound[n2 + 1];
            this.origLowerBound[n2] = this.origLowerBound[n2 + 1];
            this.upperBound[n2] = this.upperBound[n2 + 1];
            this.lowerBound[n2] = this.lowerBound[n2 + 1];
            this.basis[n2] = this.basis[n2 + 1];
            this.lower[n2] = this.lower[n2 + 1];
            if (this.scalingUsed != 0) {
                this.scale[n2] = this.scale[n2 + 1];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.nrLagrange) {
            int n4 = n;
            while (n4 <= this.columns) {
                this.lagRow[n2][n4] = this.lagRow[n2][n4 + 1];
                ++n4;
            }
            ++n2;
        }
        int n5 = this.colEnd[n - 1];
        int n6 = this.colEnd[n];
        int n7 = n6 - n5;
        n2 = n6;
        while (n2 < this.nonZeros) {
            this.mat[n5] = this.mat[n2];
            ++n5;
            ++n2;
        }
        n2 = n;
        while (n2 < this.columns) {
            this.colEnd[n2] = this.colEnd[n2 + 1] - n7;
            ++n2;
        }
        this.nonZeros -= n7;
        this.rowEndValid = 0;
        this.etaValid = 0;
        --this.sum;
        --this.columns;
    }

    public void setUpperBound(int n, double d) throws Exception {
        if (n > this.columns || n < 1) {
            throw new Exception("Column out of range");
        }
        if (this.scalingUsed != 0) {
            d /= this.scale[this.rows + n];
        }
        if (d < this.origLowerBound[this.rows + n]) {
            throw new Exception("Upperbound must be >= lowerbound");
        }
        this.etaValid = 0;
        this.origUpperBound[this.rows + n] = d;
    }

    public void setLowerBound(int n, double d) throws Exception {
        if (n > this.columns || n < 1) {
            throw new Exception("Column out of range");
        }
        if (this.scalingUsed != 0) {
            d /= this.scale[this.rows + n];
        }
        if (d > this.origUpperBound[this.rows + n]) {
            throw new Exception("Upperbound must be >= lowerbound");
        }
        this.etaValid = 0;
        this.origLowerBound[this.rows + n] = d;
    }

    public void setInt(int n, int n2) throws Exception {
        if (n > this.columns || n < 1) {
            throw new Exception("Column out of range");
        }
        this.mustBeInt[this.rows + n] = n2;
        if (n2 == 1 && this.columnsScaled != 0) {
            this.unscaleColumns();
        }
    }

    public void setRh(int n, double d) throws Exception {
        if (n > this.rows || n < 0) {
            throw new Exception("Row out of Range");
        }
        if (n == 0) {
            throw new Exception("Warning: attempt to set RHS of objective function, ignored");
        }
        this.origRh[n] = this.scalingUsed != 0 ? (this.changedSign[n] != 0 ? -d * this.scale[n] : d * this.scale[n]) : (this.changedSign[n] != 0 ? -d : d);
        this.etaValid = 0;
    }

    public void setRhVec(double[] dArray) throws Exception {
        if (this.scalingUsed != 0) {
            int n = 1;
            while (n <= this.rows) {
                this.origRh[n] = this.changedSign[n] != 0 ? -dArray[n] * this.scale[n] : dArray[n] * this.scale[n];
                ++n;
            }
        } else {
            int n = 1;
            while (n <= this.rows) {
                this.origRh[n] = this.changedSign[n] != 0 ? -dArray[n] : dArray[n];
                ++n;
            }
        }
        this.etaValid = 0;
    }

    public void strSetRhVec(String string) throws Exception {
        int n = 0;
        double[] dArray = new double[this.rows + 1];
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens() && n < this.rows) {
            dArray[++n] = Double.valueOf(stringTokenizer.nextToken());
        }
        this.setRhVec(dArray);
    }

    public void setMaximum() throws Exception {
        if (this.maximise == 0) {
            int n = 0;
            while (n < this.nonZeros) {
                if (this.mat[n].rowNr == 0) {
                    this.mat[n].value *= -1.0;
                }
                ++n;
            }
            this.etaValid = 0;
            this.origRh[0] = this.origRh[0] * -1.0;
        }
        this.maximise = 1;
        this.changedSign[0] = 1;
    }

    void setMinimum() throws Exception {
        if (this.maximise == 1) {
            int n = 0;
            while (n < this.nonZeros) {
                if (this.mat[n].rowNr == 0) {
                    this.mat[n].value = -this.mat[n].value;
                }
                ++n;
            }
            this.etaValid = 0;
            this.origRh[0] = this.origRh[0] * -1.0;
        }
        this.maximise = 0;
        this.changedSign[0] = 0;
    }

    void set_constr_type(int n, int n2) throws Exception {
        if (n > this.rows || n < 1) {
            throw new Exception("Row out of Range");
        }
        if (n2 == 1) {
            this.origUpperBound[n] = 0.0;
            this.basisValid = 0;
            if (this.changedSign[n] != 0) {
                int n3 = 0;
                while (n3 < this.nonZeros) {
                    if (this.mat[n3].rowNr == n) {
                        this.mat[n3].value *= -1.0;
                    }
                    ++n3;
                }
                this.etaValid = 0;
                this.changedSign[n] = 0;
                if (this.origRh[n] != 0.0) {
                    int n4 = n;
                    this.origRh[n4] = this.origRh[n4] * -1.0;
                }
            }
        } else if (n2 == 0) {
            this.origUpperBound[n] = this.infinite;
            this.basisValid = 0;
            if (this.changedSign[n] != 0) {
                int n5 = 0;
                while (n5 < this.nonZeros) {
                    if (this.mat[n5].rowNr == n) {
                        this.mat[n5].value *= -1.0;
                    }
                    ++n5;
                }
                this.etaValid = 0;
                this.changedSign[n] = 0;
                if (this.origRh[n] != 0.0) {
                    int n6 = n;
                    this.origRh[n6] = this.origRh[n6] * -1.0;
                }
            }
        } else if (n2 == 2) {
            this.origUpperBound[n] = this.infinite;
            this.basisValid = 0;
            if (this.changedSign[n] == 0) {
                int n7 = 0;
                while (n7 < this.nonZeros) {
                    if (this.mat[n7].rowNr == n) {
                        this.mat[n7].value *= -1.0;
                    }
                    ++n7;
                }
                this.etaValid = 0;
                this.changedSign[n] = 1;
                if (this.origRh[n] != 0.0) {
                    int n8 = n;
                    this.origRh[n8] = this.origRh[n8] * -1.0;
                }
            }
        } else {
            throw new Exception("Constraint type not (yet) implemented");
        }
    }

    public double matrixElement(int n, int n2) throws Exception {
        if (n < 0 || n > this.rows) {
            throw new Exception("Row out of range in mat_elm");
        }
        if (n2 < 1 || n2 > this.columns) {
            throw new Exception("Column out of range in mat_elm");
        }
        double d = 0.0;
        int n3 = this.colEnd[n2 - 1];
        while (this.mat[n3].rowNr != n && n3 < this.colEnd[n2]) {
            ++n3;
        }
        if (n3 != this.colEnd[n2]) {
            d = this.mat[n3].value;
            if (this.changedSign[n] != 0) {
                d = -d;
            }
            if (this.scalingUsed != 0) {
                d /= this.scale[n] * this.scale[this.rows + n2];
            }
        }
        return d;
    }

    public void getRow(int n, double[] dArray) throws Exception {
        if (n < 0 || n > this.rows) {
            throw new Exception("Row nr. out of range in get_row");
        }
        int n2 = 1;
        while (n2 <= this.columns) {
            dArray[n2] = 0.0;
            int n3 = this.colEnd[n2 - 1];
            while (n3 < this.colEnd[n2]) {
                if (this.mat[n3].rowNr == n) {
                    dArray[n2] = this.mat[n3].value;
                }
                ++n3;
            }
            if (this.scalingUsed != 0) {
                int n4 = n2;
                dArray[n4] = dArray[n4] / (this.scale[this.rows + n2] * this.scale[n]);
            }
            ++n2;
        }
        if (this.changedSign[n] != 0) {
            n2 = 0;
            while (n2 <= this.columns) {
                if (dArray[n2] != 0.0) {
                    dArray[n2] = -dArray[n2];
                }
                ++n2;
            }
        }
    }

    public void getColumn(int n, double[] dArray) throws Exception {
        if (n < 1 || n > this.columns) {
            throw new Exception("Col. nr. out of range in get_column");
        }
        int n2 = 0;
        while (n2 <= this.rows) {
            dArray[n2] = 0.0;
            ++n2;
        }
        n2 = this.colEnd[n - 1];
        while (n2 < this.colEnd[n]) {
            dArray[this.mat[n2].rowNr] = this.mat[n2].value;
            ++n2;
        }
        n2 = 0;
        while (n2 <= this.rows) {
            if (dArray[n2] != 0.0) {
                if (this.changedSign[n2] != 0) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] * -1.0;
                }
                if (this.scalingUsed != 0) {
                    int n4 = n2;
                    dArray[n4] = dArray[n4] / (this.scale[n2] * this.scale[this.rows + n]);
                }
            }
            ++n2;
        }
    }

    final double myRound(double d, double d2) throws Exception {
        return Math.abs(d) < d2 ? 0.0 : d;
    }

    public int isFeasible(double[] dArray) throws Exception {
        int n;
        int n2;
        if (this.scalingUsed != 0) {
            n2 = this.rows + 1;
            while (n2 <= this.sum) {
                if (dArray[n2 - this.rows] < this.origLowerBound[n2] * this.scale[n2] || dArray[n2 - this.rows] > this.origUpperBound[n2] * this.scale[n2]) {
                    return 0;
                }
                ++n2;
            }
        } else {
            n2 = this.rows + 1;
            while (n2 <= this.sum) {
                if (dArray[n2 - this.rows] < this.origLowerBound[n2] || dArray[n2 - this.rows] > this.origUpperBound[n2]) {
                    return 0;
                }
                ++n2;
            }
        }
        double[] dArray2 = new double[this.rows + 1];
        n2 = 0;
        while (n2 <= this.rows) {
            dArray2[n2] = 0.0;
            ++n2;
        }
        if (this.columnsScaled != 0) {
            n2 = 1;
            while (n2 <= this.columns) {
                n = this.colEnd[n2 - 1];
                while (n < this.colEnd[n2]) {
                    int n3 = this.mat[n].rowNr;
                    dArray2[n3] = dArray2[n3] + this.mat[n].value * dArray[n2] / this.scale[this.rows + n2];
                    ++n;
                }
                ++n2;
            }
        } else {
            n2 = 1;
            while (n2 <= this.columns) {
                n = this.colEnd[n2 - 1];
                while (n < this.colEnd[n2]) {
                    int n4 = this.mat[n].rowNr;
                    dArray2[n4] = dArray2[n4] + this.mat[n].value * dArray[n2];
                    ++n;
                }
                ++n2;
            }
        }
        n2 = 1;
        while (n2 <= this.rows) {
            double d = this.origRh[n2] - dArray2[n2];
            d = this.myRound(d, 0.001);
            if (this.origUpperBound[n2] == 0.0 && d != 0.0 || d < 0.0) {
                return 0;
            }
            ++n2;
        }
        return 1;
    }

    int columnInLp(double[] dArray) throws Exception {
        int n = 0;
        int n2 = 0;
        while (n2 <= this.rows) {
            if (Math.abs(dArray[n2]) > this.epsel) {
                ++n;
            }
            ++n2;
        }
        if (this.scalingUsed != 0) {
            n2 = 1;
            while (n2 <= this.columns) {
                int n3 = n;
                int n4 = this.colEnd[n2 - 1];
                while (n4 < this.colEnd[n2]) {
                    double d = this.mat[n4].value;
                    if (this.changedSign[this.mat[n4].rowNr] != 0) {
                        d = -d;
                    }
                    d /= this.scale[this.rows + n2];
                    d /= this.scale[this.mat[n4].rowNr];
                    if (Math.abs(d -= dArray[this.mat[n4].rowNr]) > this.epsel) break;
                    if (--n3 == 0) {
                        return 1;
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            n2 = 1;
            while (n2 <= this.columns) {
                int n5 = n;
                int n6 = this.colEnd[n2 - 1];
                while (n6 < this.colEnd[n2]) {
                    double d = this.mat[n6].value;
                    if (this.changedSign[this.mat[n6].rowNr] != 0) {
                        d = -d;
                    }
                    if (Math.abs(d -= dArray[this.mat[n6].rowNr]) > this.epsel) break;
                    if (--n5 == 0) {
                        return 1;
                    }
                    ++n6;
                }
                ++n2;
            }
        }
        return 0;
    }

    public void printLp() throws Exception {
        this.println(this.toString());
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[(this.rows + 1) * this.columns];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = 0.0;
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.columns) {
            n = this.colEnd[n2 - 1];
            while (n < this.colEnd[n2]) {
                dArray[(n2 - 1) * (this.rows + 1) + this.mat[n].rowNr] = this.mat[n].value;
                ++n;
            }
            ++n2;
        }
        stringBuffer.append("problem name: " + this.lpName + "\n");
        stringBuffer.append("          ");
        n = 1;
        while (n <= this.columns) {
            if (this.namesUsed != 0) {
                stringBuffer.append(this.colName[n]);
            } else {
                stringBuffer.append("Var[" + n + "] ");
            }
            ++n;
        }
        if (this.maximise != 0) {
            stringBuffer.append("\nMaximise  ");
            n = 0;
            while (n < this.columns) {
                stringBuffer.append(" " + -dArray[n * (this.rows + 1)] + " ");
                ++n;
            }
        } else {
            stringBuffer.append("\nMinimize  ");
            n = 0;
            while (n < this.columns) {
                stringBuffer.append(" " + dArray[n * (this.rows + 1)] + " ");
                ++n;
            }
        }
        stringBuffer.append("\n");
        n2 = 1;
        while (n2 <= this.rows) {
            if (this.namesUsed != 0) {
                stringBuffer.append(this.rowName[n2]);
            } else {
                stringBuffer.append("Row[" + n2 + "]  ");
            }
            n = 0;
            while (n < this.columns) {
                if (this.changedSign[n2] != 0 && dArray[n * (this.rows + 1) + n2] != 0.0) {
                    stringBuffer.append(-dArray[n * (this.rows + 1) + n2] + " ");
                } else {
                    stringBuffer.append(dArray[n * (this.rows + 1) + n2] + " ");
                }
                ++n;
            }
            if (this.origUpperBound[n2] == this.infinite) {
                if (this.changedSign[n2] != 0) {
                    stringBuffer.append(">= ");
                } else {
                    stringBuffer.append("<= ");
                }
            } else {
                stringBuffer.append(" = ");
            }
            if (this.changedSign[n2] != 0) {
                stringBuffer.append(-this.origRh[n2]);
            } else {
                stringBuffer.append(this.origRh[n2]);
            }
            ++n2;
        }
        stringBuffer.append("Type      ");
        n2 = 1;
        while (n2 <= this.columns) {
            if (this.mustBeInt[this.rows + n2] == 1) {
                stringBuffer.append("     Int ");
            } else {
                stringBuffer.append("    double ");
            }
            ++n2;
        }
        stringBuffer.append("\nupperBound      ");
        n2 = 1;
        while (n2 <= this.columns) {
            if (this.origUpperBound[this.rows + n2] == this.infinite) {
                stringBuffer.append("     Inf ");
            } else {
                stringBuffer.append(this.origUpperBound[this.rows + n2] + " ");
            }
            ++n2;
        }
        stringBuffer.append("\nlowerBound     ");
        n2 = 1;
        while (n2 <= this.columns) {
            stringBuffer.append(this.origLowerBound[this.rows + n2] + " ");
            ++n2;
        }
        stringBuffer.append("\n");
        n2 = 0;
        while (n2 < this.nrLagrange) {
            stringBuffer.append("lag[" + n2 + "]  ");
            n = 1;
            while (n <= this.columns) {
                stringBuffer.append(this.lagRow[n2][n] + " ");
                ++n;
            }
            if (this.origUpperBound[n2] == this.infinite) {
                if (this.lagConType[n2] == 2) {
                    stringBuffer.append(">= ");
                } else if (this.lagConType[n2] == 0) {
                    stringBuffer.append("<= ");
                } else if (this.lagConType[n2] == 1) {
                    stringBuffer.append(" = ");
                }
            }
            stringBuffer.append(this.lagRhs[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setRowName(int n, String string) throws Exception {
        if (this.namesUsed == 0) {
            this.rowName = new String[this.rowsAlloc + 1];
            this.colName = new String[this.columnsAlloc + 1];
            this.namesUsed = 1;
            int n2 = 0;
            while (n2 <= this.rows) {
                this.rowName[n2] = new String("r_" + n2);
                ++n2;
            }
            n2 = 1;
            while (n2 <= this.columns) {
                this.colName[n2] = new String("var_" + n2);
                ++n2;
            }
        }
        this.rowName[n] = string;
    }

    public void setColumnName(LpModel lpModel, int n, String string) throws Exception {
        if (this.namesUsed == 0) {
            this.rowName = new String[this.rowsAlloc + 1];
            this.colName = new String[this.columnsAlloc + 1];
            this.namesUsed = 1;
            int n2 = 0;
            while (n2 <= this.rows) {
                this.rowName[n2] = new String("r_" + n2);
                ++n2;
            }
            n2 = 1;
            while (n2 <= this.columns) {
                this.colName[n2] = new String("var_" + n2);
                ++n2;
            }
        }
        this.colName[n] = string;
    }

    private double minMaxToScale(double d, double d2) throws Exception {
        if (d == 0.0 || d2 == 0.0) {
            return 1.0;
        }
        double d3 = 1.0 / Math.sqrt(d * d2);
        return d3;
    }

    public void unscaleColumns() throws Exception {
        int n;
        int n2 = 1;
        while (n2 <= this.columns) {
            n = this.colEnd[n2 - 1];
            while (n < this.colEnd[n2]) {
                this.mat[n].value /= this.scale[this.rows + n2];
                ++n;
            }
            ++n2;
        }
        n = this.rows + 1;
        while (n < this.sum) {
            if (this.origLowerBound[n] != 0.0) {
                int n3 = n;
                this.origLowerBound[n3] = this.origLowerBound[n3] * this.scale[n];
            }
            if (this.origUpperBound[n] != this.infinite) {
                int n4 = n;
                this.origUpperBound[n4] = this.origUpperBound[n4] * this.scale[n];
            }
            ++n;
        }
        n = this.rows + 1;
        while (n <= this.sum) {
            this.scale[n] = 1.0;
            ++n;
        }
        this.columnsScaled = 0;
        this.etaValid = 0;
    }

    void unscale() throws Exception {
        if (this.scalingUsed != 0) {
            int n;
            int n2 = 1;
            while (n2 <= this.columns) {
                n = this.colEnd[n2 - 1];
                while (n < this.colEnd[n2]) {
                    this.mat[n].value /= this.scale[this.rows + n2];
                    ++n;
                }
                ++n2;
            }
            n = this.rows + 1;
            while (n <= this.sum) {
                if (this.origLowerBound[n] != 0.0) {
                    int n3 = n;
                    this.origLowerBound[n3] = this.origLowerBound[n3] * this.scale[n];
                }
                if (this.origUpperBound[n] != this.infinite) {
                    int n4 = n;
                    this.origUpperBound[n4] = this.origUpperBound[n4] * this.scale[n];
                }
                ++n;
            }
            n2 = 1;
            while (n2 <= this.columns) {
                n = this.colEnd[n2 - 1];
                while (n < this.colEnd[n2]) {
                    this.mat[n].value /= this.scale[this.mat[n].rowNr];
                    ++n;
                }
                ++n2;
            }
            n = 0;
            while (n <= this.rows) {
                int n5 = n;
                this.origRh[n5] = this.origRh[n5] / this.scale[n];
                ++n;
            }
            n = 0;
            while (n <= this.rows) {
                if (this.origLowerBound[n] != 0.0) {
                    int n6 = n;
                    this.origLowerBound[n6] = this.origLowerBound[n6] / this.scale[n];
                }
                if (this.origUpperBound[n] != this.infinite) {
                    int n7 = n;
                    this.origUpperBound[n7] = this.origUpperBound[n7] / this.scale[n];
                }
                ++n;
            }
            this.scalingUsed = 0;
            this.etaValid = 0;
        }
    }

    public void autoScale() throws Exception {
        int n;
        if (this.scalingUsed == 0) {
            this.scale = new double[this.sumAlloc + 1];
            n = 0;
            while (n <= this.sum) {
                this.scale[n] = 1.0;
                ++n;
            }
        }
        double[] dArray = new double[this.rows + 1];
        double[] dArray2 = new double[this.rows + 1];
        double[] dArray3 = new double[this.sum + 1];
        n = 0;
        while (n <= this.rows) {
            dArray[n] = 0.0;
            dArray2[n] = this.infinite;
            ++n;
        }
        int n2 = 1;
        while (n2 <= this.columns) {
            n = this.colEnd[n2 - 1];
            while (n < this.colEnd[n2]) {
                int n3 = this.mat[n].rowNr;
                double d = Math.abs(this.mat[n].value);
                if (d != 0.0) {
                    dArray[n3] = Math.max(dArray[n3], d);
                    dArray2[n3] = Math.min(dArray2[n3], d);
                }
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n <= this.rows) {
            dArray3[n] = this.minMaxToScale(dArray2[n], dArray[n]);
            int n4 = n;
            this.scale[n4] = this.scale[n4] * dArray3[n];
            ++n;
        }
        n2 = 1;
        while (n2 <= this.columns) {
            n = this.colEnd[n2 - 1];
            while (n < this.colEnd[n2]) {
                this.mat[n].value *= dArray3[this.mat[n].rowNr];
                ++n;
            }
            ++n2;
        }
        n = 0;
        while (n <= this.rows) {
            int n5 = n;
            this.origRh[n5] = this.origRh[n5] * dArray3[n];
            if (this.origUpperBound[n] < this.infinite && this.origUpperBound[n] != 0.0) {
                int n6 = n;
                this.origUpperBound[n6] = this.origUpperBound[n6] * dArray3[n];
            }
            if (this.origLowerBound[n] != 0.0) {
                int n7 = n;
                this.origLowerBound[n7] = this.origLowerBound[n7] * dArray3[n];
            }
            ++n;
        }
        dArray = null;
        dArray2 = null;
        n2 = 1;
        while (n2 <= this.columns) {
            if (this.mustBeInt[this.rows + n2] != 0) {
                dArray3[this.rows + n2] = 1.0;
            } else {
                double d = 0.0;
                double d2 = this.infinite;
                n = this.colEnd[n2 - 1];
                while (n < this.colEnd[n2]) {
                    if (this.mat[n].value != 0.0) {
                        d = Math.max(d, Math.abs(this.mat[n].value));
                        d2 = Math.min(d2, Math.abs(this.mat[n].value));
                    }
                    ++n;
                }
                dArray3[this.rows + n2] = this.minMaxToScale(d2, d);
                int n8 = this.rows + n2;
                this.scale[n8] = this.scale[n8] * dArray3[this.rows + n2];
            }
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.columns) {
            n = this.colEnd[n2 - 1];
            while (n < this.colEnd[n2]) {
                this.mat[n].value *= dArray3[this.rows + n2];
                ++n;
            }
            ++n2;
        }
        n = this.rows + 1;
        while (n <= this.sum) {
            if (this.origLowerBound[n] != 0.0) {
                int n9 = n;
                this.origLowerBound[n9] = this.origLowerBound[n9] / dArray3[n];
            }
            if (this.origUpperBound[n] != this.infinite) {
                int n10 = n;
                this.origUpperBound[n10] = this.origUpperBound[n10] / dArray3[n];
            }
            ++n;
        }
        this.columnsScaled = 1;
        dArray3 = null;
        this.scalingUsed = 1;
        this.etaValid = 0;
    }

    public void resetBasis() throws Exception {
        this.basisValid = 0;
    }

    public double getResult(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Invalid index: " + n);
        }
        return this.bestSolution[this.rows + n];
    }

    public void printSolution() throws Exception {
        this.println(this.solutionToString());
    }

    public String solutionToString() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Value of objective function: " + this.bestSolution[0] + "\n");
        int n = 1;
        while (n <= this.columns) {
            if (this.namesUsed != 0) {
                stringBuffer.append(this.colName[n] + " " + this.bestSolution[this.rows + n] + "\n");
            } else {
                stringBuffer.append("Var [" + n + "]  " + this.bestSolution[this.rows + n] + "\n");
            }
            ++n;
        }
        if (this.verbose != 0) {
            stringBuffer.append("\nActual values of the constraints:\n");
            n = 1;
            while (n <= this.rows) {
                if (this.namesUsed != 0) {
                    stringBuffer.append(this.rowName[n] + " " + this.bestSolution[n] + "\n");
                } else {
                    stringBuffer.append("Row [" + n + "]  " + " " + this.bestSolution[n] + "\n");
                }
                ++n;
            }
        }
        if (this.verbose != 0 || this.printDuals != 0) {
            if (this.maxLevel != 1) {
                stringBuffer.append("These are the duals from the node that gave the optimal solution.\n");
            } else {
                stringBuffer.append("\nDual values:\n");
            }
            n = 1;
            while (n <= this.rows) {
                if (this.namesUsed != 0) {
                    stringBuffer.append(this.rowName[n] + " " + this.duals[n] + "\n");
                } else {
                    stringBuffer.append("Row [" + n + "]  " + this.duals[n] + "\n");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void writeMatrix(PrintStream printStream) throws Exception {
        double[] dArray = new double[this.columns + 1];
        int n = 0;
        while (n <= this.rows) {
            this.getRow(n, dArray);
            int n2 = 1;
            while (n2 <= this.columns) {
                printStream.print(dArray[n2] + " ");
                ++n2;
            }
            printStream.println();
            ++n;
        }
    }

    public void writeLp(PrintStream printStream) throws Exception {
        double[] dArray = new double[this.columns + 1];
        if (this.maximise != 0) {
            printStream.print("max:");
        } else {
            printStream.print("min:");
        }
        this.getRow(0, dArray);
        int n = 1;
        while (n <= this.columns) {
            if (dArray[n] != 0.0) {
                if (dArray[n] == -1.0) {
                    printStream.print(" -");
                } else if (dArray[n] == 1.0) {
                    printStream.print(" +");
                } else {
                    printStream.print(dArray[n]);
                }
                if (this.namesUsed != 0) {
                    printStream.print(this.colName[n]);
                } else {
                    printStream.print("x" + n);
                }
            }
            ++n;
        }
        printStream.print(";\n");
        int n2 = 1;
        while (n2 <= this.rows) {
            if (this.namesUsed != 0) {
                printStream.print(this.rowName[n2]);
            }
            this.getRow(n2, dArray);
            n = 1;
            while (n <= this.columns) {
                if (dArray[n] != 0.0) {
                    if (dArray[n] == -1.0) {
                        printStream.print(" -");
                    } else if (dArray[n] == 1.0) {
                        printStream.print(" +");
                    } else {
                        printStream.print(" " + dArray[n] + " ");
                    }
                    if (this.namesUsed != 0) {
                        printStream.print(this.colName[n]);
                    } else {
                        printStream.print("x" + n);
                    }
                }
                ++n;
            }
            if (this.origUpperBound[n2] == 0.0) {
                printStream.print(" =");
            } else if (this.changedSign[n2] != 0) {
                printStream.print(" >");
            } else {
                printStream.print(" <");
            }
            if (this.changedSign[n2] != 0) {
                printStream.println(" " + -this.origRh[n2]);
            } else {
                printStream.println(" " + this.origRh[n2]);
            }
            ++n2;
        }
        n = this.rows + 1;
        while (n <= this.sum) {
            if (this.origLowerBound[n] != 0.0) {
                if (this.namesUsed != 0) {
                    printStream.println(this.colName[n - this.rows] + ">" + this.origLowerBound[n] + ";");
                } else {
                    printStream.print("x" + (n - this.rows) + " > " + this.origLowerBound[n] + ";");
                }
            }
            if (this.origUpperBound[n] != this.infinite) {
                if (this.namesUsed != 0) {
                    printStream.println(this.colName[n - this.rows] + " < " + this.origUpperBound[n] + ";");
                } else {
                    printStream.println("x" + (n - this.rows) + " < " + this.origUpperBound[n] + ";");
                }
            }
            ++n;
        }
        n = 1;
    }

    public void printDuals() throws Exception {
        this.println(this.dualsToString());
    }

    public String dualsToString() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n <= this.rows) {
            if (this.namesUsed != 0) {
                stringBuffer.append(this.rowName[n] + " [" + n + "] " + this.duals[n] + "\n");
            } else {
                stringBuffer.append("Dual       [" + n + "] " + this.duals[n] + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void printScales(LpModel lpModel) throws Exception {
        this.println(this.scalesToString());
    }

    public String scalesToString() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scalingUsed != 0) {
            int n = 0;
            while (n <= this.rows) {
                stringBuffer.append("Row[" + n + "]    scaled at " + this.scale[n] + "\n");
                ++n;
            }
            n = 1;
            while (n <= this.columns) {
                stringBuffer.append("Column[" + n + "] scaled at " + this.scale[this.rows + n] + "\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void ftran(double[] dArray) throws Exception {
        int n = 1;
        while (n <= this.etaSize) {
            int n2 = this.etaColEnd[n] - 1;
            int n3 = this.etaRowNr[n2];
            double d = dArray[n3];
            if (d != 0.0) {
                int n4 = this.etaColEnd[n - 1];
                n4 = this.etaColEnd[n - 1];
                while (n4 < n2) {
                    int n5 = this.etaRowNr[n4];
                    dArray[n5] = dArray[n5] + d * this.etaValue[n4];
                    ++n4;
                }
                int n6 = n3;
                dArray[n6] = dArray[n6] * this.etaValue[n2];
            }
            ++n;
        }
        n = 0;
        while (n <= this.rows) {
            dArray[n] = this.myRound(dArray[n], this.epsel);
            ++n;
        }
    }

    void btran(double[] dArray) throws Exception {
        int n = this.etaSize;
        while (n >= 1) {
            double d = 0.0;
            int n2 = this.etaColEnd[n] - 1;
            int n3 = this.etaColEnd[n - 1];
            n3 = this.etaColEnd[n - 1];
            while (n3 <= n2) {
                d += dArray[this.etaRowNr[n3]] * this.etaValue[n3];
                ++n3;
            }
            dArray[this.etaRowNr[n2]] = d = this.myRound(d, this.epsel);
            --n;
        }
    }

    public int isValid() throws Exception {
        int n;
        int n2;
        int[] nArray;
        if (this.rowEndValid == 0) {
            int[] nArray2 = new int[this.rows + 1];
            nArray = new int[this.rows + 1];
            n2 = 0;
            while (n2 <= this.rows) {
                nArray2[n2] = 0;
                nArray[n2] = 0;
                ++n2;
            }
            n2 = 0;
            while (n2 < this.nonZeros) {
                int n3 = this.mat[n2].rowNr;
                nArray[n3] = nArray[n3] + 1;
                ++n2;
            }
            this.rowEnd[0] = 0;
            n2 = 1;
            while (n2 <= this.rows) {
                this.rowEnd[n2] = this.rowEnd[n2 - 1] + nArray[n2];
                ++n2;
            }
            n2 = 1;
            while (n2 <= this.columns) {
                n = this.colEnd[n2 - 1];
                while (n < this.colEnd[n2]) {
                    int n4 = this.mat[n].rowNr;
                    if (n4 != 0) {
                        int n5 = n4;
                        nArray2[n5] = nArray2[n5] + 1;
                        this.colNo[this.rowEnd[n4 - 1] + nArray2[n4]] = n2;
                    }
                    ++n;
                }
                ++n2;
            }
            this.rowEndValid = 1;
        }
        if (this.valid != 0) {
            return 1;
        }
        nArray = new int[this.rows + 1];
        int[] nArray3 = new int[this.columns + 1];
        n2 = 1;
        while (n2 <= this.columns) {
            n = this.colEnd[n2 - 1];
            while (n < this.colEnd[n2]) {
                int n6 = n2;
                nArray3[n6] = nArray3[n6] + 1;
                int n7 = this.mat[n].rowNr;
                nArray[n7] = nArray[n7] + 1;
                ++n;
            }
            ++n2;
        }
        n2 = 1;
        while (n2 <= this.columns) {
            if (nArray3[n2] == 0) {
                if (this.namesUsed != 0) {
                    this.warning("Warning: Variable " + this.colName[n2] + " not used in any constraints\n");
                } else {
                    this.warning("Warning: Variable " + n2 + " not used in any constraints\n");
                }
            }
            ++n2;
        }
        this.valid = 1;
        return 1;
    }

    public void resizeEta(int n) throws Exception {
        while (this.etaAlloc <= n) {
            this.etaAlloc = (int)((double)this.etaAlloc * 1.5);
        }
        double[] dArray = new double[this.etaAlloc + 1];
        System.arraycopy(this.etaValue, 0, dArray, 0, this.etaValue.length);
        this.etaValue = dArray;
        int[] nArray = new int[this.etaAlloc + 1];
        System.arraycopy(this.etaRowNr, 0, nArray, 0, this.etaRowNr.length);
        this.etaRowNr = nArray;
    }

    public void condenseColumn(int n, double[] dArray) throws Exception {
        int n2 = this.etaColEnd[this.etaSize];
        int n3 = n2 + this.rows + 2;
        if (n3 >= this.etaAlloc) {
            this.resizeEta(n3);
        }
        int n4 = 0;
        while (n4 <= this.rows) {
            if (n4 != n && dArray[n4] != 0.0) {
                this.etaRowNr[n2] = n4;
                this.etaValue[n2] = dArray[n4];
                ++n2;
            }
            ++n4;
        }
        this.etaRowNr[n2] = n;
        this.etaValue[n2] = dArray[n];
        this.etaColEnd[this.etaSize + 1] = ++n2;
    }

    public double getBestSolution(int n) {
        return this.bestSolution[n];
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    private void printIndent(int n) {
        this.print("" + n);
        if (n < 50) {
            int n2 = n;
            while (n2 > 0) {
                this.print("--");
                --n2;
            }
        } else {
            this.print(" *** too deep ***");
        }
        this.print("> ");
    }

    public void debugPrintSolution(int n) {
        if (this.debug != 0) {
            int n2 = this.rows + 1;
            while (n2 <= this.sum) {
                this.printIndent(n);
                if (this.namesUsed != 0) {
                    this.println(this.colName[n2 - this.rows] + " " + this.solution[n2]);
                } else {
                    this.println("Var[" + (n2 - this.rows) + "]   " + this.solution[n2]);
                }
                ++n2;
            }
        }
    }

    public void debugPrintBounds(int n, double[] dArray, double[] dArray2) {
        if (this.debug != 0) {
            int n2 = this.rows + 1;
            while (n2 <= this.sum) {
                if (dArray2[n2] != 0.0) {
                    this.printIndent(n);
                    if (this.namesUsed != 0) {
                        this.println(this.colName[n2 - this.rows] + " > " + dArray2[n2]);
                    } else {
                        this.print("Var[" + (n2 - this.rows) + "]  > " + dArray2[n2]);
                    }
                }
                if (dArray[n2] != this.infinite) {
                    this.printIndent(n);
                    if (this.namesUsed != 0) {
                        this.println(this.colName[n2 - this.rows] + " < " + dArray[n2]);
                    } else {
                        this.println("Var[" + (n2 - this.rows) + "]  < " + dArray[n2]);
                    }
                }
                ++n2;
            }
        }
    }

    public void debugPrint(int n, String string) {
        if (this.debug != 0) {
            this.printIndent(n);
            this.print(string);
        }
    }

    public void warning(String string) {
        this.println(string);
    }

    void println(String string) {
        if (this.viewer != null) {
            this.viewer.messageln(string);
        } else {
            System.out.println(string);
        }
    }

    void print(String string) {
        if (this.viewer != null) {
            this.viewer.message(string);
        } else {
            System.out.print(string);
        }
    }
}

