/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.TranslationFailureException;
import ubc.cs.JLog.Terms.iObjectToTerm;
import ubc.cs.JLog.Terms.iTermToObject;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jFail;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jList;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jObject;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jReal;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jTrue;
import ubc.cs.JLog.Terms.jVariable;

public class jTermTranslation
implements iObjectToTerm,
iTermToObject {
    protected Hashtable createTermKeys = new Hashtable();
    protected Hashtable createObjectKeys = new Hashtable();
    protected iObjectToTerm defaultCreateTerm = null;
    protected iTermToObject defaultCreateObject = null;
    protected jPrologServices prolog = null;

    public jTermTranslation() {
        this.prolog = null;
    }

    public jTermTranslation(jPrologServices ps) {
        this.prolog = ps;
    }

    public void setDefaults() {
        this.setObjectDefaults();
        this.setTermDefaults();
    }

    protected void setObjectDefaults() {
        iTermToObject c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jInteger) {
                    return new Float(((jInteger)term).getIntegerValue());
                }
                if (term instanceof jReal) {
                    return new Float(((jReal)term).getRealValue());
                }
                throw new TranslationFailureException("Expected numerical term.");
            }
        };
        this.RegisterTermToObjectConverter(Float.class, c);
        this.RegisterTermToObjectConverter(jReal.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jInteger) {
                    return new Integer(((jInteger)term).getIntegerValue());
                }
                if (term instanceof jReal) {
                    return new Integer((int)((jReal)term).getRealValue());
                }
                throw new TranslationFailureException("Expected numerical term.");
            }
        };
        this.RegisterTermToObjectConverter(Integer.class, c);
        this.RegisterTermToObjectConverter(jInteger.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jTrue || term instanceof jAtom && term.getName().equals("true")) {
                    return Boolean.TRUE;
                }
                if (term instanceof jFail || term instanceof jAtom && term.getName().equals("fail")) {
                    return Boolean.FALSE;
                }
                throw new TranslationFailureException("Expected boolean term.");
            }
        };
        this.RegisterTermToObjectConverter(Boolean.class, c);
        this.RegisterTermToObjectConverter(jTrue.class, c);
        this.RegisterTermToObjectConverter(jFail.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jObject) {
                    return ((jObject)term).getObjectReference();
                }
                throw new TranslationFailureException("Expected jObject term.");
            }
        };
        this.RegisterTermToObjectConverter(jObject.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jList) {
                    Enumeration e = ((jList)term).elements(jTermTranslation.this);
                    Vector v = new Vector();
                    while (e.hasMoreElements()) {
                        v.addElement(e.nextElement());
                    }
                    return v;
                }
                throw new TranslationFailureException("Expected jList term.");
            }
        };
        this.RegisterTermToObjectConverter(jListPair.class, c);
        this.RegisterTermToObjectConverter(jNullList.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jVariable) {
                    return Void.TYPE;
                }
                throw new TranslationFailureException("Expected jVariable term.");
            }
        };
        this.RegisterTermToObjectConverter(jVariable.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                return term;
            }
        };
        this.RegisterTermToObjectConverter(jTerm.class, c);
        c = new iTermToObject(){

            public Object createObjectFromTerm(jTerm term) {
                if (term instanceof jAtom || term instanceof jPredicate && ((jPredicate)term).getArity() == 0) {
                    return "'" + term.toString() + "'";
                }
                return term.toString();
            }
        };
        this.RegisterTermToObjectConverter(jAtom.class, c);
        this.RegisterTermToObjectConverter(String.class, c);
        this.RegisterDefaultTermToObjectConverter(c);
    }

    protected void setTermDefaults() {
        iObjectToTerm c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                if (obj instanceof Float) {
                    return new jReal(((Float)obj).floatValue());
                }
                if (obj instanceof Double) {
                    return new jReal(((Double)obj).floatValue());
                }
                if (obj instanceof Integer) {
                    return new jReal(((Integer)obj).floatValue());
                }
                if (obj instanceof Long) {
                    return new jReal(((Long)obj).floatValue());
                }
                throw new TranslationFailureException("Expected numerical object.");
            }
        };
        this.RegisterObjectToTermConverter(Float.class, c);
        this.RegisterObjectToTermConverter(Double.class, c);
        this.RegisterObjectToTermConverter(jReal.class, c);
        c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                if (obj instanceof Short) {
                    return new jInteger(((Short)obj).intValue());
                }
                if (obj instanceof Integer) {
                    return new jInteger((Integer)obj);
                }
                if (obj instanceof Long) {
                    return new jInteger(((Long)obj).intValue());
                }
                if (obj instanceof Float) {
                    return new jInteger(((Float)obj).intValue());
                }
                if (obj instanceof Double) {
                    return new jInteger(((Double)obj).intValue());
                }
                throw new TranslationFailureException("Expected numerical term.");
            }
        };
        this.RegisterObjectToTermConverter(Short.class, c);
        this.RegisterObjectToTermConverter(Integer.class, c);
        this.RegisterObjectToTermConverter(Long.class, c);
        this.RegisterObjectToTermConverter(jInteger.class, c);
        c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj != false ? jTrue.TRUE : jFail.FAIL;
                }
                if (obj instanceof String) {
                    String s = (String)obj;
                    if (s.equalsIgnoreCase("true")) {
                        return jTrue.TRUE;
                    }
                    if (s.equalsIgnoreCase("fail")) {
                        return jFail.FAIL;
                    }
                }
                throw new TranslationFailureException("Expected boolean term.");
            }
        };
        this.RegisterObjectToTermConverter(Boolean.class, c);
        this.RegisterObjectToTermConverter(jTrue.class, c);
        this.RegisterObjectToTermConverter(jFail.class, c);
        c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                return new jObject(obj);
            }
        };
        this.RegisterObjectToTermConverter(jObject.class, c);
        c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                if (obj instanceof Vector) {
                    return jListPair.createListFromEnumeration(((Vector)obj).elements(), jTermTranslation.this);
                }
                if (obj instanceof Enumeration) {
                    return jListPair.createListFromEnumeration((Enumeration)obj, jTermTranslation.this);
                }
                throw new TranslationFailureException("Expected enumerable object.");
            }
        };
        this.RegisterObjectToTermConverter(Vector.class, c);
        this.RegisterObjectToTermConverter(Enumeration.class, c);
        c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                if (obj instanceof jTerm) {
                    return (jTerm)obj;
                }
                throw new TranslationFailureException("Expected jTerm object.");
            }
        };
        this.RegisterObjectToTermConverter(jTerm.class, c);
        c = new iObjectToTerm(){

            public jTerm createTermFromObject(Object obj) {
                if (obj instanceof jTerm) {
                    return (jTerm)obj;
                }
                return new jAtom(obj.toString());
            }
        };
        this.RegisterObjectToTermConverter(jAtom.class, c);
        if (this.prolog == null) {
            this.RegisterObjectToTermConverter(String.class, c);
            this.RegisterObjectToTermConverter(StringBuffer.class, c);
            this.RegisterDefaultObjectToTermConverter(c);
        }
        if (this.prolog != null) {
            c = new iObjectToTerm(){

                public jTerm createTermFromObject(Object obj) {
                    if (obj instanceof jTerm) {
                        return (jTerm)obj;
                    }
                    pParseStream parser = new pParseStream(obj.toString() + ".", jTermTranslation.this.prolog.getKnowledgeBase(), jTermTranslation.this.prolog.getPredicateRegistry(), jTermTranslation.this.prolog.getOperatorRegistry());
                    jTerm query = parser.parseTerm();
                    if (query != null) {
                        return query;
                    }
                    throw new TranslationFailureException("Invalid representation.");
                }
            };
            this.RegisterObjectToTermConverter(String.class, c);
            this.RegisterObjectToTermConverter(StringBuffer.class, c);
            this.RegisterDefaultObjectToTermConverter(c);
        }
    }

    public void RegisterTermToObjectConverter(Object key, iTermToObject conv) {
        this.createObjectKeys.put(key, conv);
    }

    public void RegisterDefaultTermToObjectConverter(iTermToObject conv) {
        this.defaultCreateObject = conv;
    }

    public void RegisterObjectToTermConverter(Object key, iObjectToTerm conv) {
        this.createTermKeys.put(key, conv);
    }

    public void RegisterDefaultObjectToTermConverter(iObjectToTerm conv) {
        this.defaultCreateTerm = conv;
    }

    public iObjectToTerm getObjectToTermConverter(Object key) {
        return (iObjectToTerm)this.createTermKeys.get(key);
    }

    public iObjectToTerm getDefaultObjectToTermConverter() {
        return this.defaultCreateTerm;
    }

    public iTermToObject getTermToObjectConverter(Object key) {
        return (iTermToObject)this.createObjectKeys.get(key);
    }

    public iTermToObject getDefaultTermToObjectConverter() {
        return this.defaultCreateObject;
    }

    public jTerm createTermFromObject(Object obj) {
        return this.createTermFromObject(obj, obj.getClass());
    }

    public Object createObjectFromTerm(jTerm term) {
        return this.createObjectFromTerm(term, term.getClass());
    }

    public jTerm createTermFromObject(Object obj, Object key) {
        iObjectToTerm conv = (iObjectToTerm)this.createTermKeys.get(key);
        if (conv == null) {
            conv = this.defaultCreateTerm;
        }
        if (conv != null) {
            return conv.createTermFromObject(obj);
        }
        throw new TranslationFailureException("No object to term conversion unit found.");
    }

    public Object createObjectFromTerm(jTerm term, Object key) {
        iTermToObject conv = (iTermToObject)this.createObjectKeys.get(key);
        if (conv == null) {
            conv = this.defaultCreateObject;
        }
        if (conv != null) {
            return conv.createObjectFromTerm(term);
        }
        throw new TranslationFailureException("No term to object conversion unit found.");
    }
}

