/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jEquivalenceMapping;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jRuleDefinitions;
import ubc.cs.JLog.Foundation.jUnifiedVector;
import ubc.cs.JLog.Foundation.jVariableRegistry;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Terms.Goals.jFailGoal;
import ubc.cs.JLog.Terms.InvalidPredicateNameException;
import ubc.cs.JLog.Terms.UnknownPredicateException;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jPredicate
extends iPredicate {
    protected String name;
    protected int arity;
    protected jCompoundTerm arguments;
    protected jRuleDefinitions cached_ruledefs = null;

    public jPredicate(String n, jCompoundTerm args) {
        this.name = n;
        if (this.name == null || this.name.length() <= 0) {
            throw new InvalidPredicateNameException();
        }
        this.arguments = args;
        this.arity = args.size();
        this.type = 3;
    }

    public jPredicate(jAtom a) {
        this.name = a.getName();
        this.arguments = a.getArguments();
        this.arity = 0;
        this.cached_ruledefs = a.getCachedRuleDefinitions();
        this.type = 3;
    }

    protected jPredicate(String n) {
        this.name = n;
        this.type = 3;
    }

    protected jPredicate(String n, jCompoundTerm args, int ar, jRuleDefinitions crds) {
        this.name = n;
        this.arguments = args;
        this.arity = ar;
        this.cached_ruledefs = crds;
        this.type = 3;
    }

    public final String getName() {
        return this.name;
    }

    public final int getArity() {
        return this.arity;
    }

    protected int compareArguments(iPredicate ipred, boolean first_call, boolean var_equal) {
        if (ipred instanceof jPredicate) {
            jPredicate jp = (jPredicate)ipred;
            return this.arguments.compare(jp.arguments, true, var_equal);
        }
        return first_call ? -ipred.compareArguments(this, false, var_equal) : 0;
    }

    public jRuleDefinitions getCachedRuleDefinitions() {
        return this.cached_ruledefs;
    }

    public void consult(jKnowledgeBase kb) {
        this.cached_ruledefs = kb.getRuleDefinitionsMatch(this);
        this.arguments.consult(kb);
        this.arity = this.arguments.size();
    }

    public void consultReset() {
        this.cached_ruledefs = null;
        this.arity = this.arguments.size();
        this.arguments.consultReset();
    }

    public boolean isConsultNeeded() {
        return this.cached_ruledefs == null;
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        if (this.cached_ruledefs == null && !this.lookup_predicate()) {
            goals.push(new jFailGoal());
            return;
        }
        goals.push(this.cached_ruledefs.createGoal((jCompoundTerm)this.arguments.duplicate(vars)));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        if (this.cached_ruledefs == null && !this.lookup_predicate()) {
            goals.push(new jFailGoal());
            return;
        }
        goals.push(this.cached_ruledefs.createGoal(this.arguments));
    }

    public void registerUnboundVariables(jUnifiedVector v) {
        this.arguments.registerUnboundVariables(v);
    }

    public boolean equivalence(jTerm term, jEquivalenceMapping v) {
        jTerm t = term.getTerm();
        if (this.type == t.type) {
            jPredicate pterm = (jPredicate)t;
            if (!this.name.equals(pterm.name)) {
                return false;
            }
            if (this.arity != pterm.arity) {
                return false;
            }
            return this.arguments.equivalence(pterm.arguments, v);
        }
        if (t instanceof iPredicate) {
            iPredicate iterm = (iPredicate)t;
            if (!this.name.equals(iterm.getName())) {
                return false;
            }
            if (this.getArity() != iterm.getArity()) {
                return false;
            }
            return this.arguments.equivalence(iterm.getArguments(), v);
        }
        return false;
    }

    public boolean unify(jTerm term, jUnifiedVector v) {
        if (term.type == 14) {
            return term.unify(this, v);
        }
        if (this.type == term.type) {
            jPredicate pterm = (jPredicate)term;
            if (!this.name.equals(pterm.name)) {
                return false;
            }
            if (this.arity != pterm.arity) {
                return false;
            }
            return this.arguments.unify(pterm.arguments, v);
        }
        if (term instanceof iPredicate) {
            iPredicate iterm = (iPredicate)term;
            if (!this.name.equals(iterm.getName())) {
                return false;
            }
            if (this.getArity() != iterm.getArity()) {
                return false;
            }
            return this.arguments.unify(iterm.getArguments(), v);
        }
        return false;
    }

    public final boolean equivalenceArguments(jCompoundTerm term, jEquivalenceMapping v) {
        return this.arguments.equivalence(term, v);
    }

    public final boolean unifyArguments(jCompoundTerm term, jUnifiedVector v) {
        return this.arguments.unify(term, v);
    }

    public void registerVariables(jVariableVector v) {
        this.arguments.registerVariables(v);
    }

    public void enumerateVariables(jVariableVector v, boolean all) {
        this.arguments.enumerateVariables(v, all);
    }

    public jTerm duplicate(jVariable[] vars) {
        return new jPredicate(this.name, (jCompoundTerm)this.arguments.duplicate(vars), this.arity, this.cached_ruledefs);
    }

    public jTerm copy(jVariableRegistry vars) {
        return new jPredicate(this.name, (jCompoundTerm)this.arguments.copy(vars), this.arity, this.cached_ruledefs);
    }

    public final jCompoundTerm getArguments() {
        return this.arguments;
    }

    public void addTerm(jTerm t) {
        this.arguments.addTerm(t);
        this.arity = this.arguments.size();
    }

    public void removeTerm(jTerm t) {
        this.arguments.removeTerm(t);
        this.arity = this.arguments.size();
    }

    public jCompoundTerm duplicateArguments(jVariable[] vars) {
        return (jCompoundTerm)this.arguments.duplicate(vars);
    }

    public String toString(boolean usename) {
        return this.arguments.size() > 0 ? this.name + this.arguments.toString(usename) : this.name;
    }

    protected boolean lookup_predicate() {
        Thread t = Thread.currentThread();
        if (t instanceof jPrologServiceThread) {
            jPrologServiceThread pst = (jPrologServiceThread)t;
            jPrologServices prolog = pst.getPrologServices();
            this.consultReset();
            this.consult(prolog.getKnowledgeBase());
            if (this.cached_ruledefs == null) {
                if (prolog.getFailUnknownPredicate()) {
                    return false;
                }
                throw new UnknownPredicateException(this);
            }
            return true;
        }
        throw new UnknownPredicateException(this);
    }
}

