/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jDynamicRuleDefinitions;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jRuleDefinitions;
import ubc.cs.JLog.Terms.Goals.jClauseGoal;
import ubc.cs.JLog.Terms.InvalidClauseException;
import ubc.cs.JLog.Terms.iMakeUnmake;
import ubc.cs.JLog.Terms.iNameArity;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jBinaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jTrue;
import ubc.cs.JLog.Terms.jVariable;

public class jClause
extends jBinaryBuiltinPredicate {
    public jClause(jTerm l, jTerm r) {
        super(l, r, 4);
    }

    public String getName() {
        return "clause";
    }

    public boolean prove(jClauseGoal cg, jKnowledgeBase kb) {
        jTerm t;
        jTerm l = cg.lhs.getTerm();
        jTerm r = cg.rhs.getTerm();
        jPredicate p = this.getPredicate(l);
        jDynamicRuleDefinitions dfd = cg.getDynamicRules();
        if (dfd == null) {
            dfd = this.getDynamicRules(p, kb);
            cg.setDynamicRules(dfd);
        }
        if ((t = dfd.getClause(cg, p)) != null) {
            jTerm tnew = t;
            if (t instanceof iMakeUnmake) {
                tnew = ((iMakeUnmake)((Object)t)).unmake();
            }
            if (tnew == null) {
                tnew = jTrue.TRUE;
            }
            return r.unify(tnew, cg.unified);
        }
        return false;
    }

    protected jPredicate getPredicate(jTerm t) {
        if (t instanceof jPredicate) {
            return (jPredicate)t;
        }
        if (t instanceof jAtom) {
            return new jPredicate((jAtom)t);
        }
        this.throwError(t);
        return null;
    }

    protected jDynamicRuleDefinitions getDynamicRules(jPredicate h, jKnowledgeBase kb) {
        jRuleDefinitions rds = h.getCachedRuleDefinitions();
        if (rds == null) {
            rds = kb.getRuleDefinitionsMatch(h);
        }
        if (rds instanceof jDynamicRuleDefinitions) {
            return ((jDynamicRuleDefinitions)rds).copy();
        }
        this.throwError(h);
        return null;
    }

    protected void throwError(jTerm t) {
        StringBuffer sb = new StringBuffer();
        sb.append("Clause term '");
        if (t instanceof iNameArity) {
            sb.append(t.getName() + "/" + String.valueOf(((iNameArity)((Object)t)).getArity()));
        } else {
            sb.append(t.getName());
        }
        sb.append("' must be dynamic.");
        throw new InvalidClauseException(sb.toString());
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jClauseGoal(this, this.lhs.duplicate(vars), this.rhs.duplicate(vars)));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jClauseGoal(this, this.lhs, this.rhs));
    }

    protected jBinaryBuiltinPredicate duplicate(jTerm l, jTerm r) {
        return new jClause(l, r);
    }
}

