/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pArray;
import ubc.cs.JLog.Parser.pComma;
import ubc.cs.JLog.Parser.pEOF;
import ubc.cs.JLog.Parser.pEndBrace;
import ubc.cs.JLog.Parser.pEndBracket;
import ubc.cs.JLog.Parser.pEndParen;
import ubc.cs.JLog.Parser.pInteger;
import ubc.cs.JLog.Parser.pListCons;
import ubc.cs.JLog.Parser.pName;
import ubc.cs.JLog.Parser.pPreToken;
import ubc.cs.JLog.Parser.pPreTokenizeStream;
import ubc.cs.JLog.Parser.pReal;
import ubc.cs.JLog.Parser.pStartBrace;
import ubc.cs.JLog.Parser.pStartBracket;
import ubc.cs.JLog.Parser.pStartParen;
import ubc.cs.JLog.Parser.pTSPreToken;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pTokenizerTable;
import ubc.cs.JLog.Parser.pUnaryNumber;
import ubc.cs.JLog.Parser.pVariable;

class pTokenizeStream {
    protected pPreTokenizeStream tokenizer;
    protected pTokenizerTable table;
    protected pTokenizerTable string_table;
    protected pTokenizerTable linecomment_table;
    protected pTokenizerTable comment_table;
    protected pTokenizerTable array_table;
    protected pTokenizerTable singles_table;
    protected pTokenizerTable basenumber_table;
    protected Stack pushback;
    protected int currentLine;
    protected int currentChar;
    protected static final int TOKEN_SINGLEQUOTE = 65281;
    protected static final int TOKEN_QUOTE = 65282;
    protected static final int TOKEN_STARTPAREN = 65283;
    protected static final int TOKEN_ENDPAREN = 65284;
    protected static final int TOKEN_STARTBRACE = 65285;
    protected static final int TOKEN_ENDBRACE = 65286;
    protected static final int TOKEN_STARTBRACKET = 65287;
    protected static final int TOKEN_ENDBRACKET = 65288;
    protected static final int TOKEN_COMMA = 65289;
    protected static final int TOKEN_PERIOD = 65290;
    protected static final int TOKEN_SEMICOLON = 65291;
    protected static final int TOKEN_LINECOMMENT = 65292;
    protected static final int TOKEN_CUT = 65293;
    protected static final int TOKEN_LISTCONS = 65294;
    protected static final int TOKEN_FORWARDSLASH = 65295;
    protected static final int TOKEN_STAR = 65296;
    protected static final int TOKEN_WHITESPACE = 2;
    protected static final int TOKEN_WORDS = 3;
    protected static final int TOKEN_SECONDARYWORDS = 4;
    protected static final int TOKEN_NUMBERS = 5;

    public pTokenizeStream(String s) {
        this.tokenizer = new pPreTokenizeStream(new StringReader(s));
        this.initTokenizer();
    }

    public pTokenizeStream(Reader r) {
        this.tokenizer = new pPreTokenizeStream(r);
        this.initTokenizer();
    }

    protected void initTokenizer() {
        this.pushback = new Stack();
        this.table = new pTokenizerTable();
        this.string_table = new pTokenizerTable();
        this.array_table = new pTokenizerTable();
        this.linecomment_table = new pTokenizerTable();
        this.comment_table = new pTokenizerTable();
        this.singles_table = new pTokenizerTable();
        this.basenumber_table = new pTokenizerTable();
        this.currentLine = 0;
        this.currentChar = 0;
        this.initTable();
        this.initStringTable();
        this.initArrayTable();
        this.initLineCommentTable();
        this.initCommentTable();
        this.initSinglesTable();
        this.initBaseNumberTable();
        this.tokenizer.useTokenizerTable(this.table);
    }

    protected void initTable() {
        this.table.setTokenType(37, 65292);
        this.table.setTokenType(65, 90, 3);
        this.table.setTokenType(97, 122, 3);
        this.table.setTokenType(95, 3);
        this.table.setTokenType(48, 57, 5);
        this.table.setTokenType(34, 65282);
        this.table.setTokenType(39, 65281);
        this.table.setTokenType(0, 32, 2);
        this.table.setTokenType(10, 1);
        this.table.setTokenType(13, 1);
        this.table.setTokenType(40, 65283);
        this.table.setTokenType(41, 65284);
        this.table.setTokenType(123, 65285);
        this.table.setTokenType(125, 65286);
        this.table.setTokenType(91, 65287);
        this.table.setTokenType(93, 65288);
        this.table.setTokenType(124, 65294);
        this.table.setTokenType(44, 65289);
        this.table.setTokenType(46, 65290);
        this.table.setTokenType(59, 65291);
        this.table.setTokenType(33, 65293);
        this.table.setTokenType(47, 65295);
        this.table.setTokenType(42, 65296);
        this.table.setTokenType(58, 4);
        this.table.setTokenType(45, 4);
        this.table.setTokenType(43, 4);
        this.table.setTokenType(61, 4);
        this.table.setTokenType(60, 4);
        this.table.setTokenType(62, 4);
        this.table.setTokenType(92, 4);
        this.table.setTokenType(126, 4);
        this.table.setTokenType(96, 4);
        this.table.setTokenType(35, 4);
        this.table.setTokenType(38, 4);
        this.table.setTokenType(63, 4);
        this.table.setTokenType(36, 4);
        this.table.setTokenType(64, 4);
        this.table.setTokenType(94, 4);
    }

    protected void initSinglesTable() {
        this.singles_table.setTokenType(0, 31, 2);
        this.singles_table.setTokenType(32, 255, 65280);
        this.singles_table.setTokenType(10, 1);
        this.singles_table.setTokenType(13, 1);
    }

    protected void initBaseNumberTable() {
        this.basenumber_table.setTokenType(0, 31, 2);
        this.basenumber_table.setTokenType(48, 57, 3);
        this.basenumber_table.setTokenType(65, 90, 3);
        this.basenumber_table.setTokenType(97, 122, 3);
        this.basenumber_table.setTokenType(10, 1);
        this.basenumber_table.setTokenType(13, 1);
    }

    protected void initStringTable() {
        this.string_table.setTokenType(0, 31, 2);
        this.string_table.setTokenType(32, 255, 3);
        this.string_table.setTokenType(10, 1);
        this.string_table.setTokenType(13, 1);
        this.string_table.setTokenType(39, 65281);
    }

    protected void initArrayTable() {
        this.array_table.setTokenType(0, 31, 2);
        this.array_table.setTokenType(32, 255, 3);
        this.array_table.setTokenType(10, 1);
        this.array_table.setTokenType(13, 1);
        this.array_table.setTokenType(34, 65282);
    }

    protected void initLineCommentTable() {
        this.linecomment_table.setTokenType(0, 255, 3);
        this.linecomment_table.setTokenType(10, 1);
        this.linecomment_table.setTokenType(13, 1);
    }

    protected void initCommentTable() {
        this.comment_table.setTokenType(0, 255, 3);
        this.comment_table.setTokenType(10, 1);
        this.comment_table.setTokenType(13, 1);
        this.comment_table.setTokenType(47, 65295);
        this.comment_table.setTokenType(42, 65296);
    }

    public void pushBackToken(pToken t) {
        this.pushback.push(t);
    }

    public pToken getNextToken() {
        while (this.pushback.empty()) {
            pTSPreToken pt = this.read();
            switch (pt.getType()) {
                case -1: {
                    return new pEOF(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 3: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseWords();
                }
                case 4: 
                case 65296: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseSecondaryWords();
                }
                case 65282: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseArray();
                }
                case 65281: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseString();
                }
                case 5: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseNumbers();
                }
                case 65283: {
                    return new pStartParen(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65284: {
                    return new pEndParen(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65285: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseBrace();
                }
                case 65286: {
                    return new pEndBrace(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65287: {
                    return new pStartBracket(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65288: {
                    return new pEndBracket(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65294: {
                    return new pListCons(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65289: {
                    return new pComma(pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65290: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parsePeriod();
                }
                case 65291: {
                    pTSPreToken pt_la = this.read();
                    boolean predicate = pt_la.getType() == 65283;
                    this.tokenizer.pushBackToken(pt_la);
                    return new pName(";", predicate, pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65293: {
                    pTSPreToken pt_la = this.read();
                    boolean predicate = pt_la.getType() == 65283;
                    this.tokenizer.pushBackToken(pt_la);
                    return new pName("!", predicate, pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                case 65292: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseLineComment();
                }
                case 65295: {
                    this.tokenizer.pushBackToken(pt);
                    return this.parseForwardSlash();
                }
            }
        }
        return (pToken)this.pushback.pop();
    }

    protected pToken parseBrace() {
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 65285) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pTSPreToken pt2 = this.read();
        if (pt2.getType() == 65286) {
            pTSPreToken pt3 = this.read();
            boolean predicate = pt3.getType() == 65283;
            this.tokenizer.pushBackToken(pt3);
            return new pName("{}", predicate, pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.pushBackToken(pt2);
        return new pStartBrace(pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    protected pToken parsePeriod() {
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 65290) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pTSPreToken pt2 = this.read();
        if (pt2.getType() == 5) {
            this.tokenizer.pushBackToken(pt2);
            this.tokenizer.pushBackToken(pt1);
            return this.parseNumbers();
        }
        if (pt2.getType() == 65290 || pt2.getType() == 4) {
            this.tokenizer.pushBackToken(pt2);
            this.tokenizer.pushBackToken(pt1);
            return this.parseSecondaryWords();
        }
        boolean predicate = pt2.getType() == 65283;
        this.tokenizer.pushBackToken(pt2);
        return new pName(".", predicate, pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    protected pToken parseLineComment() {
        pTSPreToken pt2;
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 65292) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.linecomment_table);
        while ((pt2 = this.read()).getType() == 3) {
        }
        this.tokenizer.pushBackToken(pt2);
        this.tokenizer.popTokenizerTable();
        return this.getNextToken();
    }

    protected pToken parseComment() {
        pTSPreToken pt1 = this.read();
        pTSPreToken pt2 = this.read();
        if (pt1.getType() != 65295 || pt2.getType() != 65296) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.comment_table);
        boolean found = false;
        boolean laststar = false;
        do {
            found = (pt2 = this.read()).getType() == 65295 && laststar;
            boolean bl = laststar = pt2.getType() == 65296;
        } while (pt2.getType() != -1 && !found);
        if (pt2.getType() == -1) {
            throw new SyntaxErrorException("Premature end of file.  Comment without end at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.popTokenizerTable();
        return this.getNextToken();
    }

    protected pToken parseString() {
        pTSPreToken pt2;
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 65281) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.string_table);
        StringBuffer sb = new StringBuffer();
        do {
            if ((pt2 = this.read()).getType() != 3) continue;
            sb.append(pt2.getToken());
        } while (pt2.getType() == 3 || pt2.getType() == 2);
        if (pt2.getType() == 1) {
            throw new SyntaxErrorException("Premature end of line.  String without end at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        if (pt2.getType() == -1) {
            throw new SyntaxErrorException("Premature end of file.  String without end at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.popTokenizerTable();
        pTSPreToken pt3 = this.read();
        boolean predicate = pt3.getType() == 65283;
        this.tokenizer.pushBackToken(pt3);
        return new pName(sb.toString(), predicate, pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    protected pToken parseArray() {
        pTSPreToken pt2;
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 65282) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.useTokenizerTable(this.array_table);
        StringBuffer sb = new StringBuffer();
        do {
            if ((pt2 = this.read()).getType() != 3) continue;
            sb.append(pt2.getToken());
        } while (pt2.getType() == 3 || pt2.getType() == 2);
        if (pt2.getType() == 1) {
            throw new SyntaxErrorException("Premature end of line.  Character array without end at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        if (pt2.getType() == -1) {
            throw new SyntaxErrorException("Premature end of file.  Character array without end at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.popTokenizerTable();
        return new pArray(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    protected pToken parseWords() {
        pTSPreToken pt2;
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 3) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pt1.getToken());
        do {
            if ((pt2 = this.read()).getType() != 3 && pt2.getType() != 5) continue;
            sb.append(pt2.getToken());
        } while (pt2.getType() == 3 || pt2.getType() == 5);
        boolean predicate = pt2.getType() == 65283;
        this.tokenizer.pushBackToken(pt2);
        if (sb.charAt(0) >= 'A' && sb.charAt(0) <= 'Z' || sb.charAt(0) == '_') {
            return new pVariable(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        return new pName(sb.toString(), predicate, pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    protected pToken parseSecondaryWords() {
        boolean found;
        pTSPreToken pt2;
        pTSPreToken pt1 = this.read();
        int type = pt1.getType();
        if (type != 4 && type != 65290 && type != 65295 && type != 65296) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pt1.getToken());
        if (pt1.getToken().equals("-") || pt1.getToken().equals("+")) {
            pt2 = this.read();
            type = pt2.getType();
            this.tokenizer.pushBackToken(pt2);
            if (type == 5) {
                pName sgn = new pName(sb.toString(), false, pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
                pToken unum = this.parseNumbers();
                return new pUnaryNumber(sgn, unum);
            }
        }
        do {
            found = false;
            pt2 = this.read();
            type = pt2.getType();
            if (type != 4 && type != 65290 && type != 65295 && type != 65296) continue;
            sb.append(pt2.getToken());
            found = true;
        } while (found);
        boolean predicate = pt2.getType() == 65283;
        this.tokenizer.pushBackToken(pt2);
        return new pName(sb.toString(), predicate, pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected pToken parseNumbers() {
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 5 && pt1.getType() != 65290) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(pt1.getToken());
        if (pt1.getType() == 65290) {
            pTSPreToken pt2 = this.read();
            if (pt2.getType() != 5) {
                throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            }
            sb.append(pt2.getToken());
            pTSPreToken pt3 = this.read();
            if (pt3.getType() == 3 && pt3.getToken().equalsIgnoreCase("e")) {
                pTSPreToken pt4 = this.read();
                if (pt4.getType() == 4 && (pt4.getToken().equals("-") || pt4.getToken().equals("+"))) {
                    pTSPreToken pt5 = this.read();
                    if (pt5.getType() != 5) {
                        throw new SyntaxErrorException("Expected number after sign at ", pt4.getPosition(), pt4.getLine(), pt4.getCharPos());
                    }
                    sb.append(pt3.getToken());
                    sb.append(pt4.getToken());
                    sb.append(pt5.getToken());
                    return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
                } else {
                    if (pt4.getType() != 5) throw new SyntaxErrorException("Expected '+','-', or number after 'e' at ", pt3.getPosition(), pt3.getLine(), pt3.getCharPos());
                    sb.append(pt3.getToken());
                    sb.append(pt4.getToken());
                }
                return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            } else {
                this.tokenizer.pushBackToken(pt3);
            }
            return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pTSPreToken pt2 = this.read();
        if (pt2.getType() == 65290) {
            pTSPreToken pt3 = this.read();
            if (pt3.getType() == 5) {
                sb.append(pt2.getToken());
                sb.append(pt3.getToken());
                pTSPreToken pt4 = this.read();
                if (pt4.getType() == 3 && pt4.getToken().equalsIgnoreCase("e")) {
                    pTSPreToken pt5 = this.read();
                    if (pt5.getType() == 4 && (pt5.getToken().equals("-") || pt5.getToken().equals("+"))) {
                        pTSPreToken pt6 = this.read();
                        if (pt6.getType() != 5) {
                            throw new SyntaxErrorException("Expected number after sign at ", pt5.getPosition(), pt5.getLine(), pt5.getCharPos());
                        }
                        sb.append(pt4.getToken());
                        sb.append(pt5.getToken());
                        sb.append(pt6.getToken());
                        return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
                    } else {
                        if (pt5.getType() != 5) throw new SyntaxErrorException("Expected '+', '-', or number after 'e' at ", pt4.getPosition(), pt4.getLine(), pt4.getCharPos());
                        sb.append(pt4.getToken());
                        sb.append(pt5.getToken());
                    }
                    return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
                } else {
                    this.tokenizer.pushBackToken(pt4);
                }
                return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            }
            this.tokenizer.pushBackToken(pt3);
            this.tokenizer.pushBackToken(pt2);
            return new pInteger(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        if (pt2.getType() == 65281) {
            int basenum;
            String base = sb.toString();
            try {
                basenum = Integer.valueOf(base);
            }
            catch (NumberFormatException e) {
                throw new TokenizeStreamException("Error in tokenizer.  Expected integer at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            }
            if (basenum == 0) {
                this.tokenizer.useTokenizerTable(this.singles_table);
                pt2 = this.read();
                this.tokenizer.popTokenizerTable();
                return new pInteger(base, pt2.getToken(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            }
            if (basenum < 2 || basenum > 36) throw new SyntaxErrorException("Number base must be 0 or 2..36 at", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            this.tokenizer.useTokenizerTable(this.basenumber_table);
            pt2 = this.read();
            this.tokenizer.popTokenizerTable();
            return new pInteger(base, pt2.getToken(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        if (pt2.getType() == 3 && pt2.getToken().equalsIgnoreCase("e")) {
            pTSPreToken pt3 = this.read();
            if (pt3.getType() == 4 && (pt3.getToken().equals("-") || pt3.getToken().equals("+"))) {
                pTSPreToken pt4 = this.read();
                if (pt4.getType() != 5) {
                    throw new SyntaxErrorException("Expected number after sign at ", pt4.getPosition(), pt4.getLine(), pt4.getCharPos());
                }
                sb.append(pt2.getToken());
                sb.append(pt3.getToken());
                sb.append(pt4.getToken());
                return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            } else {
                if (pt3.getType() != 5) throw new SyntaxErrorException("Expected '+', '-', or number after 'e' at ", pt2.getPosition(), pt2.getLine(), pt2.getCharPos());
                sb.append(pt2.getToken());
                sb.append(pt3.getToken());
            }
            return new pReal(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        this.tokenizer.pushBackToken(pt2);
        return new pInteger(sb.toString(), pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
    }

    protected pToken parseForwardSlash() {
        pTSPreToken pt1 = this.read();
        if (pt1.getType() != 65295) {
            throw new TokenizeStreamException("Error in Tokenizer.  Unexpected token at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pTSPreToken pt2 = this.read();
        this.tokenizer.pushBackToken(pt2);
        this.tokenizer.pushBackToken(pt1);
        if (pt2.getType() == 65296) {
            return this.parseComment();
        }
        return this.parseSecondaryWords();
    }

    protected pTSPreToken peekNextToken() {
        pTSPreToken pt = this.read();
        this.tokenizer.pushBackToken(pt);
        return pt;
    }

    protected boolean peekNextTokenType(int type) {
        pTSPreToken pt = this.read();
        this.tokenizer.pushBackToken(pt);
        return pt.getType() == type;
    }

    protected pTSPreToken read() {
        pTSPreToken tspt;
        pPreToken pt = this.tokenizer.getNextToken();
        if (!(pt instanceof pTSPreToken)) {
            tspt = new pTSPreToken(pt.getToken(), pt.getType(), pt.getPosition(), this.currentLine, this.currentChar);
            if (pt.getType() == 1) {
                this.currentLine += this.countLines(pt.getToken());
                this.currentChar = 0;
            } else {
                this.currentChar += pt.getToken().length();
            }
        } else {
            tspt = (pTSPreToken)pt;
        }
        return tspt;
    }

    protected int countLines(String s) {
        boolean lastlf = false;
        int count = 0;
        int len = s.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = s.charAt(pos);
            if (c == '\r') {
                lastlf = true;
                ++count;
                continue;
            }
            if (c == '\n' && lastlf) {
                lastlf = false;
                continue;
            }
            lastlf = false;
            ++count;
        }
        return count;
    }
}

