/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import ubc.cs.JLog.Foundation.InvalidLibraryEntryException;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Terms.InvalidPredicateNameException;
import ubc.cs.JLog.Terms.iNameArity;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jVariable;

public abstract class pPredicateEntry
implements iNameArity {
    public static final int NARY_ARITY = -1;
    protected String name;
    protected int arity;
    protected String library = null;

    public pPredicateEntry(String name, int arity) {
        this.name = name;
        this.arity = arity;
        if (name == null || name.length() <= 0) {
            throw new InvalidPredicateNameException();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean isArity(int a) {
        return this.arity == a;
    }

    public void setLibrary(String lib) {
        if (this.library != null) {
            throw new InvalidLibraryEntryException();
        }
        this.library = lib;
    }

    public String getLibrary() {
        return this.library;
    }

    public boolean sameLibrary(String lib) {
        if (this.library == null && lib == null) {
            return true;
        }
        if (this.library == null || lib == null) {
            return false;
        }
        return this.library.equals(lib);
    }

    public iPredicate createPredicate(pToken pt, jCompoundTerm cterm) {
        if (!this.isArity(cterm.size())) {
            throw new SyntaxErrorException("Term with arity " + String.valueOf(this.arity) + " expected for predicate at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
        }
        return this.createPredicate(cterm);
    }

    public iPredicate createPredicate() {
        jCompoundTerm cterm = new jCompoundTerm();
        for (int i = 0; i < this.arity; ++i) {
            cterm.addTerm(new jVariable("_"));
        }
        return this.createPredicate(cterm);
    }

    public abstract iPredicate createPredicate(jCompoundTerm var1);

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "/" + Integer.toString(this.getArity()));
        String lib = this.getLibrary();
        if (lib != null) {
            sb.append(" library:" + lib);
        }
        return sb.toString();
    }
}

