/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.io.Reader;
import java.util.Stack;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pArray;
import ubc.cs.JLog.Parser.pArrayList;
import ubc.cs.JLog.Parser.pComma;
import ubc.cs.JLog.Parser.pCommand;
import ubc.cs.JLog.Parser.pCons;
import ubc.cs.JLog.Parser.pDCG;
import ubc.cs.JLog.Parser.pEOF;
import ubc.cs.JLog.Parser.pEndBrace;
import ubc.cs.JLog.Parser.pEndBracket;
import ubc.cs.JLog.Parser.pEndParen;
import ubc.cs.JLog.Parser.pIf;
import ubc.cs.JLog.Parser.pInteger;
import ubc.cs.JLog.Parser.pList;
import ubc.cs.JLog.Parser.pListCons;
import ubc.cs.JLog.Parser.pName;
import ubc.cs.JLog.Parser.pNumber;
import ubc.cs.JLog.Parser.pOperator;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPacket;
import ubc.cs.JLog.Parser.pParens;
import ubc.cs.JLog.Parser.pPredicate;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Parser.pReal;
import ubc.cs.JLog.Parser.pStartBrace;
import ubc.cs.JLog.Parser.pStartBracket;
import ubc.cs.JLog.Parser.pStartParen;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pTokenizeStream;
import ubc.cs.JLog.Parser.pUnaryNumber;
import ubc.cs.JLog.Parser.pVar;
import ubc.cs.JLog.Parser.pVariable;
import ubc.cs.JLog.Terms.Entries.pCommandOperatorEntry;
import ubc.cs.JLog.Terms.Entries.pConsOperatorEntry;
import ubc.cs.JLog.Terms.Entries.pDCGOperatorEntry;
import ubc.cs.JLog.Terms.Entries.pIfOperatorEntry;

class pPreParseStream {
    protected pTokenizeStream tokenizer;
    protected pPredicateRegistry predicates;
    protected pOperatorRegistry operators;

    public pPreParseStream(String s, pPredicateRegistry pr, pOperatorRegistry or) {
        this.tokenizer = new pTokenizeStream(s);
        this.predicates = pr;
        this.operators = or;
    }

    public pPreParseStream(Reader r, pPredicateRegistry pr, pOperatorRegistry or) {
        this.tokenizer = new pTokenizeStream(r);
        this.predicates = pr;
        this.operators = or;
    }

    public pPacket parse() {
        pPacket pak = this.parseTerm(false);
        pToken pt = this.tokenizer.getNextToken();
        if (pt instanceof pEOF && pak == null || pt instanceof pName && ((pName)pt).getToken().equals(".")) {
            return pak;
        }
        throw new SyntaxErrorException("Expected '.' at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
    }

    protected pParens parseParens() {
        pToken pt1 = this.tokenizer.getNextToken();
        if (!(pt1 instanceof pStartParen)) {
            throw new SyntaxErrorException("Expected '(' at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pPacket pak = this.parseTerm(false);
        pToken pt2 = this.tokenizer.getNextToken();
        if (pt2 instanceof pEndParen) {
            return new pParens((pStartParen)pt1, pak);
        }
        throw new SyntaxErrorException("Expected ')' at ", pt2.getPosition(), pt2.getLine(), pt2.getCharPos());
    }

    protected pPredicate parseBrace() {
        pToken pt1 = this.tokenizer.getNextToken();
        if (!(pt1 instanceof pStartBrace)) {
            throw new SyntaxErrorException("Expected '{' at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pPacket pak = this.parseTerm(false);
        pToken pt2 = this.tokenizer.getNextToken();
        if (pt2 instanceof pEndBrace) {
            return new pPredicate(this.predicates, "{}", pt1, new pParens((pStartBrace)pt1, pak));
        }
        throw new SyntaxErrorException("Expected '}' at ", pt2.getPosition(), pt2.getLine(), pt2.getCharPos());
    }

    protected pList parseList() {
        pPacket pak2 = null;
        pToken pt1 = this.tokenizer.getNextToken();
        if (!(pt1 instanceof pStartBracket)) {
            throw new SyntaxErrorException("Expected '[' at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
        }
        pPacket pak1 = this.parseTerm(false);
        pToken pt2 = this.tokenizer.getNextToken();
        if (pt2 instanceof pListCons) {
            if (pak1 == null) {
                throw new SyntaxErrorException("Expected term after '[' at ", pt1.getPosition(), pt1.getLine(), pt1.getCharPos());
            }
            pak2 = this.parseTerm(true);
            if (pak2 == null) {
                throw new SyntaxErrorException("Expected term after '|' at ", pt2.getPosition(), pt2.getLine(), pt2.getCharPos());
            }
            pt2 = this.tokenizer.getNextToken();
        }
        if (pt2 instanceof pEndBracket) {
            return new pList(pt1, pak1, pak2);
        }
        throw new SyntaxErrorException("Expected ']' at ", pt2.getPosition(), pt2.getLine(), pt2.getCharPos());
    }

    protected pPacket parseTerm(boolean single) {
        Stack paks = new Stack();
        boolean need_lhsop = false;
        while (true) {
            pPacket pp;
            pToken pt;
            if ((pt = this.tokenizer.getNextToken()) instanceof pComma && single) {
                this.tokenizer.pushBackToken(pt);
                return this.finalizePacketStack(paks);
            }
            if (pt instanceof pName && !need_lhsop && ((pName)pt).isPotentialPredicate()) {
                pp = new pPredicate(this.predicates, pt, this.parseParens());
            } else if (pt instanceof pStartBrace && !need_lhsop) {
                this.tokenizer.pushBackToken(pt);
                pp = this.parseBrace();
            } else if (pt instanceof pStartBracket && !need_lhsop) {
                this.tokenizer.pushBackToken(pt);
                pp = this.parseList();
            } else if (pt instanceof pStartParen && !need_lhsop) {
                this.tokenizer.pushBackToken(pt);
                pp = this.parseParens();
            } else if (pt instanceof pArray && !need_lhsop) {
                pp = new pArrayList((pArray)pt);
            } else if (pt instanceof pVariable && !need_lhsop) {
                pp = new pVar((pVariable)pt);
            } else if ((pt instanceof pReal || pt instanceof pInteger || pt instanceof pUnaryNumber) && !need_lhsop) {
                pp = new pNumber(pt);
            } else {
                if (pt instanceof pUnaryNumber) {
                    this.tokenizer.pushBackToken(((pUnaryNumber)pt).getValue());
                    this.tokenizer.pushBackToken(((pUnaryNumber)pt).getSign());
                    continue;
                }
                pp = this.packetizeToken(pt, need_lhsop);
                if (pp == null || need_lhsop && !(pp instanceof pOperator)) {
                    this.tokenizer.pushBackToken(pt);
                    return this.finalizePacketStack(paks);
                }
            }
            need_lhsop = !(pp instanceof pOperator) || !((pOperator)pp).hasRHS();
            this.updatePacketStack(paks, pp);
        }
    }

    protected void updatePacketStack(Stack paks, pPacket pp) {
        block11: {
            if (paks.empty()) {
                paks.push(pp);
            } else if (pp instanceof pOperator && ((pOperator)pp).hasLHS()) {
                pOperator ppo = (pOperator)pp;
                pPacket spp = (pPacket)paks.pop();
                if (spp instanceof pOperator) {
                    pOperator sppo = (pOperator)spp;
                    while (true) {
                        if (ppo.getPriority() < sppo.getPriority() || ppo.getPriority() == sppo.getPriority() && !sppo.isNonAssociativeRight()) {
                            ppo.setLHS(sppo.getRHS());
                            sppo.setRHS(ppo);
                            paks.push(sppo);
                            paks.push(ppo);
                            break block11;
                        }
                        if (ppo.getPriority() > sppo.getPriority() && paks.empty() || ppo.getPriority() == sppo.getPriority() && !ppo.isNonAssociativeLeft()) {
                            ppo.setLHS(sppo);
                            if (!paks.empty()) {
                                ((pOperator)paks.peek()).setRHS(ppo);
                            }
                            paks.push(ppo);
                            break block11;
                        }
                        if (paks.empty()) break;
                        sppo = (pOperator)paks.pop();
                    }
                    pToken opt = pp.getToken();
                    throw new SyntaxErrorException("Parentheses required. Associativity rules do not permit use of operator at ", opt.getPosition(), opt.getLine(), opt.getCharPos());
                }
                ppo.setLHS(spp);
                paks.push(ppo);
            } else {
                pOperator sppo = (pOperator)paks.peek();
                if (pp instanceof pOperator) {
                    pOperator ppo = (pOperator)pp;
                    pToken opt = pp.getToken();
                    if (ppo.getPriority() > sppo.getPriority() || ppo.getPriority() == sppo.getPriority() && sppo.isNonAssociativeRight()) {
                        throw new SyntaxErrorException("Operator with lower priority number or parenthesis expected for operator at ", opt.getPosition(), opt.getLine(), opt.getCharPos());
                    }
                    paks.push(ppo);
                }
                sppo.setRHS(pp);
            }
        }
    }

    protected pPacket finalizePacketStack(Stack paks) {
        if (paks.empty()) {
            return null;
        }
        pPacket last = (pPacket)paks.peek();
        if (last instanceof pOperator) {
            ((pOperator)last).verifyCompletion();
        }
        return (pPacket)paks.firstElement();
    }

    protected pPacket packetizeToken(pToken pt, boolean need_lhsop) {
        if (!(pt instanceof pName) && !(pt instanceof pComma)) {
            return null;
        }
        pOperatorEntry oe = this.operators.getOperator(pt.getToken(), need_lhsop);
        if (oe != null) {
            if (pt instanceof pComma && oe instanceof pConsOperatorEntry) {
                return new pCons((pConsOperatorEntry)oe, pt);
            }
            if (oe instanceof pIfOperatorEntry) {
                return new pIf((pIfOperatorEntry)oe, pt);
            }
            if (oe instanceof pCommandOperatorEntry) {
                return new pCommand((pCommandOperatorEntry)oe, pt);
            }
            if (oe instanceof pDCGOperatorEntry) {
                return new pDCG((pDCGOperatorEntry)oe, pt);
            }
            return new pOperator(oe, pt);
        }
        if (need_lhsop) {
            return null;
        }
        return new pPredicate(this.predicates, pt);
    }
}

