/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.util.Enumeration;
import java.util.Hashtable;
import ubc.cs.JLog.Foundation.UnmatchedRuleException;
import ubc.cs.JLog.Foundation.jDynamicRuleDefinitions;
import ubc.cs.JLog.Foundation.jRule;
import ubc.cs.JLog.Foundation.jRuleDefinitions;
import ubc.cs.JLog.Terms.iNameArity;

public class jKnowledgeBase {
    protected Hashtable definitions = new Hashtable();

    public void addRuleDefinitions(jRuleDefinitions rds) {
        jRuleDefinitions rdsmatch = this.getRuleDefinitionsMatch(rds);
        if (rdsmatch == null) {
            this.definitions.put(this.getKeyString(rds), rds);
        } else if (!rdsmatch.sameLibrary(rds.getLibrary())) {
            String err = "Rules " + rdsmatch.getName() + "/" + rdsmatch.getArity() + " already exists" + (rdsmatch.getLibrary() != null ? " in library " + rdsmatch.getLibrary() : "");
            throw new UnmatchedRuleException(err);
        }
    }

    public void addRule(jRule r) {
        jRuleDefinitions rds = this.getRuleDefinitionsMatch(r);
        if (rds == null) {
            rds = new jRuleDefinitions(r.getName(), r.getArity());
            this.definitions.put(this.getKeyString(r), rds);
        }
        rds.addRule(r);
    }

    public void addRuleFirst(jRule r) {
        jRuleDefinitions rds = this.getRuleDefinitionsMatch(r);
        if (rds == null) {
            rds = new jRuleDefinitions(r.getName(), r.getArity());
            this.definitions.put(this.getKeyString(r), rds);
        }
        rds.addRuleFirst(r);
    }

    public void addRuleLast(jRule r) {
        jRuleDefinitions rds = this.getRuleDefinitionsMatch(r);
        if (rds == null) {
            rds = new jRuleDefinitions(r.getName(), r.getArity());
            this.definitions.put(this.getKeyString(r), rds);
        }
        rds.addRuleLast(r);
    }

    public void removeRule(jRule r) {
        jRuleDefinitions rds = this.getRuleDefinitionsMatch(r);
        if (rds != null) {
            rds.removeRule(r);
        }
    }

    public void clearRules() {
        this.definitions = new Hashtable();
    }

    public Enumeration enumDefinitions() {
        return this.definitions.elements();
    }

    public synchronized void makeRuleDefinitionDynamic(iNameArity r) {
        jRuleDefinitions rds = this.getRuleDefinitionsMatch(r);
        if (rds == null) {
            this.definitions.put(this.getKeyString(r), new jDynamicRuleDefinitions(r.getName(), r.getArity()));
        } else if (!(rds instanceof jDynamicRuleDefinitions)) {
            this.definitions.put(this.getKeyString(r), new jDynamicRuleDefinitions(rds));
        }
    }

    public jRuleDefinitions getRuleDefinitionsMatch(iNameArity r) {
        return (jRuleDefinitions)this.definitions.get(this.getKeyString(r));
    }

    public void consult() {
        Enumeration e = this.enumDefinitions();
        while (e.hasMoreElements()) {
            jRuleDefinitions rds = (jRuleDefinitions)e.nextElement();
            rds.consult(this);
        }
    }

    protected String getKeyString(iNameArity r) {
        return r.getName() + "/" + Integer.toString(r.getArity());
    }
}

