/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.PrintWriter;
import ubc.cs.JLog.Foundation.iPrologServiceText;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pParseStream;

public class jConsultSourceThread
extends jPrologServiceThread {
    protected iPrologServiceText source;
    protected PrintWriter errors;
    protected jPrologServiceBroadcaster begin = null;
    protected jPrologServiceBroadcaster end = null;

    public jConsultSourceThread(jPrologServices ps, iPrologServiceText s, PrintWriter e) {
        super(ps);
        this.setName("ConsultSourceThread");
        this.source = s;
        this.errors = e;
    }

    public void setListeners(jPrologServiceBroadcaster b, jPrologServiceBroadcaster e, jPrologServiceBroadcaster s) {
        this.setStoppedListeners(s);
        this.begin = b;
        this.end = e;
    }

    public void run() {
        if (this.begin != null) {
            this.begin.broadcastEvent(new jPrologServiceEvent());
        }
        this.errors.println("consulting.");
        this.errors.flush();
        try {
            pParseStream parser = new pParseStream(this.source.getText(), this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
            try {
                parser.parseSource();
                this.prolog.getKnowledgeBase().consult();
                this.errors.print("completed.");
                this.errors.flush();
            }
            catch (SyntaxErrorException e) {
                this.errors.println("SYNTAX ERROR:");
                this.errors.println(e.toString() + "\n");
                this.source.setCaretPosition(e.getPosition());
                this.source.select(e.getPosition(), e.getPosition() + 1);
                this.errors.print("terminated.");
                this.errors.flush();
                this.source.requestFocus();
            }
            catch (TokenizeStreamException e) {
                this.errors.println("INTERNAL ERROR:");
                this.errors.println(e.toString() + "\n");
                this.source.setCaretPosition(e.getPosition());
                this.source.select(e.getPosition(), e.getPosition() + 1);
                this.errors.print("terminated.");
                this.errors.flush();
                this.source.requestFocus();
            }
            catch (RuntimeException e) {
                this.errors.println("ERROR:");
                this.errors.println(e.toString() + "\n");
                this.errors.print("terminated.");
                this.errors.flush();
                this.source.requestFocus();
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error e) {
            this.errors.println("JAVA ERROR:");
            this.errors.println(e.toString() + "\n");
            this.errors.print("terminated.");
            this.errors.flush();
            this.source.requestFocus();
            throw e;
        }
        finally {
            if (this.allow_release) {
                this.prolog.release();
            }
            if (this.end != null) {
                this.end.broadcastEvent(new jPrologServiceEvent());
            }
        }
    }

    public boolean isCurrentlyConsulting() {
        return true;
    }

    public void printOutput(String s) {
        this.errors.print(s);
        this.errors.flush();
    }
}

