/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import java.util.Enumeration;
import ubc.cs.JLog.Builtins.Goals.jTermToListGoal;
import ubc.cs.JLog.Builtins.InvalidTermToListArgumentException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Parser.pOperatorEntry;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPredicateEntry;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jBinaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jConjunctTerm;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jTermToList
extends jBinaryBuiltinPredicate {
    public jTermToList(jTerm l, jTerm r) {
        super(l, r, 4);
    }

    public String getName() {
        return "=..";
    }

    public boolean prove(jTermToListGoal tg, pPredicateRegistry pr, pOperatorRegistry or) {
        jTerm l = tg.lhs.getTerm();
        jTerm r = tg.rhs.getTerm();
        if (l instanceof iPredicate) {
            jListPair prev;
            jCompoundTerm ct = ((iPredicate)l).getArguments();
            Enumeration e = ct.enumTerms();
            jListPair head = prev = new jListPair(new jAtom(l.getName()), null);
            while (e.hasMoreElements()) {
                jListPair next = new jListPair((jTerm)e.nextElement(), null);
                prev.setTail(next);
                prev = next;
            }
            prev.setTail(jNullList.NULL_LIST);
            return r.unify(head, tg.unified);
        }
        if (l instanceof jConjunctTerm) {
            jListPair head = new jListPair(new jAtom(l.getName()), new jListPair(((jConjunctTerm)l).getLHS(), new jListPair(((jConjunctTerm)l).getRHS(), jNullList.NULL_LIST)));
            return r.unify(head, tg.unified);
        }
        if (r instanceof jListPair) {
            jTerm p;
            jListPair lst = (jListPair)r;
            jTerm name = lst.getHead().getTerm();
            if (!(name instanceof iPredicate) || ((iPredicate)name).getArity() != 0) {
                throw new InvalidTermToListArgumentException();
            }
            jCompoundTerm ct = new jCompoundTerm();
            jTerm next = lst.getTail().getTerm();
            while (next instanceof jListPair) {
                lst = (jListPair)next;
                ct.addTerm(lst.getHead().getTerm());
                next = lst.getTail().getTerm();
            }
            if (!(next instanceof jNullList)) {
                throw new InvalidTermToListArgumentException();
            }
            pPredicateEntry pe = pr.getPredicate(name.getName(), ct.size());
            if (pe != null) {
                p = pe.createPredicate(ct);
            } else {
                pOperatorEntry oe = or.getOperator(name.getName(), true);
                if (oe != null) {
                    if (ct.size() != 2) {
                        throw new InvalidTermToListArgumentException();
                    }
                    jTerm lhs = ct.elementAt(0);
                    jTerm rhs = ct.elementAt(1);
                    p = oe.createOperator(lhs, rhs);
                } else {
                    p = new jPredicate(name.getName(), ct);
                }
            }
            return l.unify(p, tg.unified);
        }
        throw new InvalidTermToListArgumentException();
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jTermToListGoal(this, this.lhs.duplicate(vars), this.rhs.duplicate(vars)));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jTermToListGoal(this, this.lhs, this.rhs));
    }

    protected jBinaryBuiltinPredicate duplicate(jTerm l, jTerm r) {
        return new jTermToList(l, r);
    }
}

