/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Builtins.Goals.jSortGoal;
import ubc.cs.JLog.Builtins.InvalidSortSourceListException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Terms.jBinaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jList;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class jSort
extends jBinaryBuiltinPredicate {
    protected boolean var_equal = false;

    public jSort(jTerm l, jTerm r) {
        super(l, r, 4);
    }

    public jSort(jTerm l, jTerm r, boolean ve) {
        super(l, r, 4);
        this.var_equal = ve;
    }

    public String getName() {
        return "sort";
    }

    public boolean prove(jSortGoal sg) {
        jTerm l = sg.lhs.getTerm();
        jTerm r = sg.rhs.getTerm();
        if (!(l instanceof jList)) {
            throw new InvalidSortSourceListException();
        }
        jList sorted = this.sort(l, sg.var_equal);
        return r.unify(sorted, sg.unified);
    }

    protected jList sort(jTerm src, boolean ve) {
        Vector dest = new Vector();
        src = src.getTerm();
        while (src.type == 12) {
            this.sort_insert(((jListPair)src).getHead(), dest, ve);
            src = ((jListPair)src).getTail().getTerm();
        }
        if (src != null && src.type != 13) {
            this.sort_insert(src, dest, ve);
        }
        return this.sort_makelist(dest);
    }

    protected jList sort_makelist(Vector dest) {
        Enumeration e = dest.elements();
        jListPair prev = null;
        jList dlst = null;
        while (e.hasMoreElements()) {
            jTerm t = (jTerm)e.nextElement();
            if (prev == null) {
                prev = new jListPair(t, null);
                dlst = prev;
                continue;
            }
            jListPair nlst = new jListPair(t, null);
            prev.setTail(nlst);
            prev = nlst;
        }
        if (prev != null) {
            prev.setTail(jNullList.NULL_LIST);
        } else {
            dlst = jNullList.NULL_LIST;
        }
        return dlst;
    }

    protected int sort_compare(jTerm l, jTerm r, boolean ve) {
        return l.compare(r, ve);
    }

    protected void sort_insert(jTerm t, Vector v, boolean ve) {
        int max = v.size();
        for (int i = 0; i < max; ++i) {
            int result = this.sort_compare((jTerm)v.elementAt(i), t, ve);
            switch (result) {
                case 1: {
                    v.insertElementAt(t, i);
                }
                case 0: {
                    return;
                }
            }
        }
        v.insertElementAt(t, v.size());
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jSortGoal(this, this.lhs.duplicate(vars), this.rhs.duplicate(vars), this.var_equal));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jSortGoal(this, this.lhs, this.rhs, this.var_equal));
    }

    public jBinaryBuiltinPredicate duplicate(jTerm l, jTerm r) {
        return new jSort(l, r, this.var_equal);
    }
}

