/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import java.util.Random;
import ubc.cs.JLog.Builtins.InvalidArithmeticOperationException;
import ubc.cs.JLog.Builtins.jUnaryArithmetic;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Terms.jInteger;
import ubc.cs.JLog.Terms.jReal;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jUnaryBuiltinPredicate;

public class jRandom
extends jUnaryArithmetic {
    public jRandom(jTerm r) {
        super(r);
    }

    public String getName() {
        return "random";
    }

    public jTerm getValue() {
        jTerm r = this.rhs.getValue();
        if (r.type == 1) {
            return new jInteger(this.operatorInt(((jInteger)r).getIntegerValue()));
        }
        if (r.type == 2) {
            return new jReal(this.operatorReal(((jReal)r).getRealValue()));
        }
        throw new InvalidArithmeticOperationException();
    }

    protected jUnaryBuiltinPredicate duplicate(jTerm r) {
        return new jRandom(r);
    }

    protected int operatorInt(int r) {
        Thread t = Thread.currentThread();
        if (r < 1) {
            throw new InvalidArithmeticOperationException();
        }
        if (t instanceof jPrologServiceThread) {
            jPrologServiceThread pst = (jPrologServiceThread)t;
            Random gen = pst.getPrologServices().getRandomGenerator();
            double val = gen.nextDouble();
            int result = (int)Math.floor((double)r * val);
            result = result < r ? result : 0;
            return result;
        }
        throw new InvalidArithmeticOperationException();
    }

    protected float operatorReal(float r) {
        Thread t = Thread.currentThread();
        if (t instanceof jPrologServiceThread) {
            jPrologServiceThread pst = (jPrologServiceThread)t;
            Random gen = pst.getPrologServices().getRandomGenerator();
            return r * gen.nextFloat();
        }
        throw new InvalidArithmeticOperationException();
    }
}

