/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import ubc.cs.JLog.Builtins.Goals.jCompareGoal;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jTrinaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jVariable;

public class jCompare
extends jTrinaryBuiltinPredicate {
    protected boolean var_equal = false;

    public jCompare(jTerm t1, jTerm t2, jTerm t3) {
        super(t1, t2, t3, 4);
    }

    public jCompare(jTerm t1, jTerm t2, jTerm t3, boolean ve) {
        super(t1, t2, t3, 4);
        this.var_equal = ve;
    }

    public String getName() {
        return "compare";
    }

    public boolean prove(jCompareGoal cg) {
        jTerm t1 = cg.term1.getTerm();
        jTerm t2 = cg.term2.getTerm();
        jTerm t3 = cg.term3.getTerm();
        int result = t2.compare(t3, cg.var_equal);
        if (t1 instanceof iPredicate && ((iPredicate)t1).getArity() == 0) {
            if (t1.getName().equals("=")) {
                return result == 0;
            }
            if (t1.getName().equals("<")) {
                return result == -1;
            }
            if (t1.getName().equals(">")) {
                return result == 1;
            }
        } else {
            switch (result) {
                case 0: {
                    return t1.unify(new jAtom("="), cg.unified);
                }
                case -1: {
                    return t1.unify(new jAtom("<"), cg.unified);
                }
                case 1: {
                    return t1.unify(new jAtom(">"), cg.unified);
                }
            }
        }
        return false;
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jCompareGoal(this, this.term1.duplicate(vars), this.term2.duplicate(vars), this.term3.duplicate(vars), this.var_equal));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jCompareGoal(this, this.term1, this.term2, this.term3, this.var_equal));
    }

    protected jTrinaryBuiltinPredicate duplicate(jTerm t1, jTerm t2, jTerm t3) {
        return new jCompare(t1, t2, t3, this.var_equal);
    }
}

