/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins.Goals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import ubc.cs.JLog.Builtins.MissingInputServicesException;
import ubc.cs.JLog.Builtins.jRead;
import ubc.cs.JLog.Foundation.InvalidInputException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jUnifiedVector;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.jTerm;

public class jReadGoal
extends jGoal {
    protected jRead read;
    public jTerm term;
    public jUnifiedVector unified;

    public jReadGoal(jRead r, jTerm t) {
        this.read = r;
        this.term = t;
        this.unified = new jUnifiedVector();
    }

    public boolean prove(iGoalStack goals, iGoalStack proved) {
        jTerm in = this.getInput();
        if (this.read.prove(this, in)) {
            proved.push(this);
            return true;
        }
        this.unified.restoreVariables();
        goals.push(this);
        return false;
    }

    public boolean retry(iGoalStack goals, iGoalStack proved) {
        this.unified.restoreVariables();
        goals.push(this);
        return false;
    }

    public void internal_restore(iGoalStack goals) {
        this.unified.restoreVariables();
    }

    protected jTerm getInput() {
        Thread thread = Thread.currentThread();
        if (thread instanceof jPrologServiceThread) {
            jPrologServiceThread pst = (jPrologServiceThread)thread;
            jPrologServices prolog = pst.getPrologServices();
            BufferedReader in = prolog.getInput();
            PrintWriter out = prolog.getOutput();
            String input = null;
            if (in == null) {
                throw new MissingInputServicesException("InputStream Services unavailable");
            }
            while (input == null) {
                try {
                    input = in.readLine();
                }
                catch (IOException e) {
                    throw new InvalidInputException();
                }
                if (input == null) {
                    throw new InvalidInputException();
                }
                pParseStream parser = new pParseStream(input, prolog.getKnowledgeBase(), prolog.getPredicateRegistry(), prolog.getOperatorRegistry());
                try {
                    jTerm trm = parser.parseTerm();
                    if (trm != null) {
                        out.println(trm.toString(true));
                        out.flush();
                        return trm;
                    }
                    throw new InvalidInputException();
                }
                catch (SyntaxErrorException e) {
                    out.println(input);
                    out.println("SYNTAX ERROR:");
                    out.println(e.toString());
                    out.flush();
                    input = null;
                    out.println("Try Again...\n");
                    out.flush();
                }
                catch (TokenizeStreamException e) {
                    out.println(input);
                    out.println("INTERNAL ERROR:");
                    out.println(e.toString());
                    out.flush();
                    input = null;
                    out.println("Try Again...\n");
                    out.flush();
                }
            }
            throw new InvalidInputException();
        }
        throw new MissingInputServicesException();
    }

    public String getName() {
        return this.read.getName();
    }

    public int getArity() {
        return this.read.getArity();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "/" + String.valueOf(this.getArity()) + " goal: ");
        sb.append(this.getName() + "(" + this.term.toString() + ")");
        return sb.toString();
    }
}

