/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.json.expression.member;

import net.sf.jasperreports.json.JsonNodeContainer;
import net.sf.jasperreports.json.expression.member.AbstractMemberExpression;
import net.sf.jasperreports.json.expression.member.MemberExpression;
import net.sf.jasperreports.json.expression.member.evaluation.MemberExpressionEvaluatorVisitor;

public class ArraySliceExpression
extends AbstractMemberExpression {
    private Integer start;
    private Integer end;

    public ArraySliceExpression(MemberExpression.DIRECTION direction, Integer start, Integer end) {
        this.start = start;
        this.end = end;
        this.setDirection(direction);
    }

    @Override
    public JsonNodeContainer evaluate(JsonNodeContainer nodeContainer, MemberExpressionEvaluatorVisitor evaluator) {
        return evaluator.evaluateArraySlice(this, nodeContainer);
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getEnd() {
        return this.end;
    }

    public String toString() {
        String result = (Object)((Object)this.getDirection()) + " [" + (this.start != null ? this.start : "START") + ":" + (this.end != null ? this.end : "END") + "]";
        if (this.getFilterExpression() != null) {
            result = result + "(" + this.getFilterExpression() + ")";
        }
        return result;
    }
}

