/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.json.expression;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import net.sf.jasperreports.json.JRJsonNode;
import net.sf.jasperreports.json.JsonNodeContainer;
import net.sf.jasperreports.json.expression.EvaluationContext;
import net.sf.jasperreports.json.expression.JsonQLExpression;
import net.sf.jasperreports.json.expression.filter.evaluation.DefaultFilterExpressionEvaluatorVisitor;
import net.sf.jasperreports.json.expression.filter.evaluation.FilterExpressionEvaluatorVisitor;
import net.sf.jasperreports.json.expression.member.MemberExpression;
import net.sf.jasperreports.json.expression.member.evaluation.DefaultMemberExpressionEvaluatorVisitor;
import net.sf.jasperreports.json.expression.member.evaluation.DefaultMemberExpressionEvaluatorVisitorForFilter;
import net.sf.jasperreports.json.expression.member.evaluation.MemberExpressionEvaluatorVisitor;
import net.sf.jasperreports.json.util.JsonUtil;

public class JsonQLExpressionEvaluator {
    private EvaluationContext evaluationContext = new EvaluationContext(){

        @Override
        public FilterExpressionEvaluatorVisitor getFilterExpressionEvaluatorVisitor() {
            return new DefaultFilterExpressionEvaluatorVisitor(this);
        }

        @Override
        public MemberExpressionEvaluatorVisitor getMemberExpressionEvaluatorVisitor() {
            return new DefaultMemberExpressionEvaluatorVisitor(this);
        }

        @Override
        public MemberExpressionEvaluatorVisitor getMemberExpressionEvaluatorVisitorForFilter() {
            return new DefaultMemberExpressionEvaluatorVisitorForFilter(this);
        }

        @Override
        public ObjectMapper getObjectMapper() {
            return JsonUtil.createObjectMapper();
        }
    };

    public JsonNodeContainer evaluate(JsonQLExpression expression, JRJsonNode contextNode) {
        List<MemberExpression> memberExpressionList = expression.getMemberExpressionList();
        JsonNodeContainer result = new JsonNodeContainer(contextNode);
        if (memberExpressionList != null) {
            for (MemberExpression me : memberExpressionList) {
                result = me.evaluate(result, this.evaluationContext.getMemberExpressionEvaluatorVisitor());
                if (result != null) continue;
                return null;
            }
        }
        return result;
    }

    public EvaluationContext getEvaluationContext() {
        return this.evaluationContext;
    }
}

