/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.javascript;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.util.CompositeExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.ExpressionChunkVisitor;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.javascript.JavaScriptCompileData;
import net.sf.jasperreports.javascript.JavaScriptCompilerBase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptCompiler
extends JavaScriptCompilerBase {
    public JavaScriptCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        Context context = ContextFactory.getGlobal().enterContext();
        try {
            JavaScriptCompilerBase.Errors errors = new JavaScriptCompilerBase.Errors();
            for (int i = 0; i < units.length; ++i) {
                JRCompilationUnit unit = units[i];
                JavaScriptCompileData compileData = new JavaScriptCompileData();
                JRSourceCompileTask compileTask = unit.getCompileTask();
                for (JRExpression expr : compileTask.getExpressions()) {
                    int id = compileTask.getExpressionId(expr);
                    JavaScriptCompilerBase.ScriptExpressionVisitor defaultVisitor = this.defaultExpressionCreator();
                    JRExpressionUtil.visitChunks((JRExpression)expr, (ExpressionChunkVisitor)defaultVisitor);
                    String defaultExpression = defaultVisitor.getScript();
                    try {
                        context.compileString(defaultExpression, "expression", 0, null);
                    }
                    catch (EvaluatorException e) {
                        errors.addError(e);
                    }
                    if (errors.hasErrors()) continue;
                    JavaScriptCompilerBase.ScriptExpressionVisitor oldVisitor = this.oldExpressionCreator();
                    JavaScriptCompilerBase.ScriptExpressionVisitor estimatedVisitor = this.estimatedExpressionCreator();
                    JRExpressionUtil.visitChunks((JRExpression)expr, (ExpressionChunkVisitor)new CompositeExpressionChunkVisitor(new ExpressionChunkVisitor[]{oldVisitor, estimatedVisitor}));
                    compileData.addExpression(id, defaultExpression, estimatedVisitor.getScript(), oldVisitor.getScript());
                }
                if (errors.hasErrors()) continue;
                unit.setCompileData((Serializable)compileData);
            }
            String string = errors.errorMessage();
            return string;
        }
        finally {
            Context.exit();
        }
    }
}

