/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JavaScriptCompiledData
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_TOO_MANY_EXPRESSIONs = "compilers.javascript.too.many.expressions";
    private final List<ExpressionIndexes> expressionIndexes = new ArrayList<ExpressionIndexes>();
    private final List<CompiledClass> compiledClasses = new ArrayList<CompiledClass>(1);

    protected static int makeExpressionIndex(int scriptIndex, int expressionId) {
        if (scriptIndex > Short.MAX_VALUE || expressionId > Short.MAX_VALUE) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_TOO_MANY_EXPRESSIONs, (Object[])null);
        }
        return (scriptIndex & Short.MAX_VALUE) << 16 | expressionId & Short.MAX_VALUE;
    }

    protected static int scriptIndex(int expressionIndex) {
        return expressionIndex >> 16 & Short.MAX_VALUE;
    }

    protected static int expressionId(int expressionIndex) {
        return expressionIndex & Short.MAX_VALUE;
    }

    public void addExpression(int expressionId, int defaultExpressionIdx, int oldExpressionIdx, int estimatedExpressionIdx) {
        for (int idx = this.expressionIndexes.size(); idx <= expressionId; ++idx) {
            this.expressionIndexes.add(idx, null);
        }
        ExpressionIndexes expressionData = new ExpressionIndexes(defaultExpressionIdx, oldExpressionIdx, estimatedExpressionIdx);
        this.expressionIndexes.set(expressionId, expressionData);
    }

    public ExpressionIndexes getExpression(int id) {
        if (id >= this.expressionIndexes.size()) {
            throw new JRRuntimeException("compilers.javascript.expression.not.found", new Object[]{id});
        }
        ExpressionIndexes expr = this.expressionIndexes.get(id);
        if (expr == null) {
            throw new JRRuntimeException("compilers.javascript.expression.not.found", new Object[]{id});
        }
        return expr;
    }

    public void addClass(String className, byte[] data) {
        this.compiledClasses.add(new CompiledClass(className, data));
    }

    public CompiledClass getCompiledClass(int classIndex) {
        return this.compiledClasses.get(classIndex);
    }

    protected static class ExpressionIndexes
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final int defaultExpressionIdx;
        private final int oldExpressionIdx;
        private final int estimatedExpressionIdx;

        public ExpressionIndexes(int defaultExpressionIdx, int oldExpressionIdx, int estimatedExpressionIdx) {
            this.defaultExpressionIdx = defaultExpressionIdx;
            this.oldExpressionIdx = oldExpressionIdx;
            this.estimatedExpressionIdx = estimatedExpressionIdx;
        }

        public int getDefaultExpressionIndex() {
            return this.defaultExpressionIdx;
        }

        public int getOldExpressionIndex() {
            return this.oldExpressionIdx;
        }

        public int getEstimatedExpressionIndex() {
            return this.estimatedExpressionIdx;
        }
    }

    protected static class CompiledClass
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final String className;
        private final byte[] classBytes;

        public CompiledClass(String className, byte[] classBytes) {
            this.className = className;
            this.classBytes = classBytes;
        }

        public String getClassName() {
            return this.className;
        }

        public byte[] getClassBytes() {
            return this.classBytes;
        }
    }
}

