/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.javascript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRRuntimeException;

public class JavaScriptCompileData
implements Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String EXCEPTION_MESSAGE_KEY_EXPRESSION_NOT_FOUND = "compilers.javascript.expression.not.found";
    private final List<Expression> expressions = new ArrayList<Expression>();

    public void addExpression(int expressionId, Expression expression) {
        for (int idx = this.expressions.size(); idx <= expressionId; ++idx) {
            this.expressions.add(idx, null);
        }
        this.expressions.set(expressionId, expression);
    }

    public void addExpression(int expressionId, String defaultExpression, String estimatedExpression, String oldExpression) {
        Expression expression = new Expression(defaultExpression, estimatedExpression, oldExpression);
        this.addExpression(expressionId, expression);
    }

    public Expression getExpression(int id) {
        if (id >= this.expressions.size()) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EXPRESSION_NOT_FOUND, new Object[]{id});
        }
        Expression expr = this.expressions.get(id);
        if (expr == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EXPRESSION_NOT_FOUND, new Object[]{id});
        }
        return expr;
    }

    protected static class Expression
    implements Serializable {
        private static final long serialVersionUID = 10200L;
        private final String defaultExpression;
        private final String oldExpression;
        private final String estimatedExpression;

        public Expression(String defaultExpression, String estimatedExpression, String oldExpression) {
            this.defaultExpression = defaultExpression;
            this.estimatedExpression = estimatedExpression;
            this.oldExpression = oldExpression;
        }

        public String getDefaultExpression() {
            return this.defaultExpression;
        }

        public String getOldExpression() {
            return this.oldExpression;
        }

        public String getEstimatedExpression() {
            return this.estimatedExpression;
        }
    }
}

