/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.jdbc;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapter;
import net.sf.jasperreports.data.jdbc.TransactionIsolation;
import net.sf.jasperreports.dataadapters.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.util.SecretsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    private static final Log log = LogFactory.getLog(JdbcDataAdapterService.class);
    public static final String EXCEPTION_MESSAGE_KEY_PASSWORD_REQUIRED = "data.jdbc.password.required";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_URL = "data.jdbc.invalid.url";
    public static final String EXCEPTION_MESSAGE_KEY_CONNECTION_NOT_CREATED = "data.jdbc.connection.not.created";
    private Connection connection = null;

    public JdbcDataAdapterService(ParameterContributorContext paramContribContext, JdbcDataAdapter jdbcDataAdapter) {
        super(paramContribContext, jdbcDataAdapter);
    }

    public JdbcDataAdapter getJdbcDataAdapter() {
        return (JdbcDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        try {
            this.connection = this.getConnection();
        }
        catch (SQLException e) {
            throw new JRException((Throwable)e);
        }
        parameters.put("REPORT_CONNECTION", this.connection);
    }

    protected String getUrlForConnection() {
        JdbcDataAdapter jdbcDataAdapter = this.getJdbcDataAdapter();
        if (jdbcDataAdapter != null) {
            return jdbcDataAdapter.getUrl();
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        JdbcDataAdapter jdbcDataAdapter = this.getJdbcDataAdapter();
        if (jdbcDataAdapter != null) {
            ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClassLoader(oldThreadClassLoader));
                Class clazz = JRClassLoader.loadClassForRealName((String)jdbcDataAdapter.getDriver());
                Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Properties connectProps = new Properties();
                Map<String, String> map = jdbcDataAdapter.getProperties();
                if (map != null) {
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        connectProps.setProperty(entry.getKey(), entry.getValue());
                    }
                }
                String password = jdbcDataAdapter.getPassword();
                SecretsUtil secretService = SecretsUtil.getInstance((JasperReportsContext)this.getJasperReportsContext());
                if (secretService != null) {
                    password = secretService.getSecret("net.sf.jasperreports.data.adapter", password);
                }
                connectProps.setProperty("user", jdbcDataAdapter.getUsername());
                connectProps.setProperty("password", password);
                this.connection = driver.connect(this.getUrlForConnection(), connectProps);
                if (this.connection == null) {
                    boolean urlValid = driver.acceptsURL(this.getUrlForConnection());
                    if (!urlValid) {
                        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INVALID_URL, new Object[]{this.getUrlForConnection(), jdbcDataAdapter.getDriver()});
                    }
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CONNECTION_NOT_CREATED, new Object[]{this.getUrlForConnection()});
                }
                this.setupConnection(jdbcDataAdapter);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JRRuntimeException((Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
            }
            return this.connection;
        }
        return null;
    }

    protected void setupConnection(JdbcDataAdapter dataAdapter) throws SQLException {
        Integer transactionIsolation;
        Boolean readOnly;
        JRDataset dataset;
        JRPropertiesUtil props = JRPropertiesUtil.getInstance((JasperReportsContext)this.getJasperReportsContext());
        Boolean autoCommit = this.getAutoCommit(dataAdapter, props, dataset = this.getParameterContributorContext().getDataset());
        if (autoCommit != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting auto commit " + autoCommit + " on connection " + this.connection));
            }
            this.connection.setAutoCommit(autoCommit);
        }
        if ((readOnly = this.getReadOnly(dataAdapter, props, dataset)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting read only " + readOnly + " on connection " + this.connection));
            }
            this.connection.setReadOnly(readOnly);
        }
        if ((transactionIsolation = this.getTransactionIsolation(dataAdapter, props, dataset)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("setting transaction isolation " + transactionIsolation + " on connection " + this.connection));
            }
            this.connection.setTransactionIsolation(transactionIsolation);
        }
    }

    protected Boolean getAutoCommit(JdbcDataAdapter dataAdapter, JRPropertiesUtil props, JRDataset dataset) {
        Boolean autoCommit = dataAdapter.getAutoCommit();
        if (autoCommit != null) {
            return autoCommit;
        }
        return props.getBooleanProperty((JRPropertiesHolder)dataset, "net.sf.jasperreports.jdbc.data.adapter.auto.commit");
    }

    protected Boolean getReadOnly(JdbcDataAdapter dataAdapter, JRPropertiesUtil props, JRDataset dataset) {
        Boolean readOnly = dataAdapter.getReadOnly();
        if (readOnly != null) {
            return readOnly;
        }
        return props.getBooleanProperty((JRPropertiesHolder)dataset, "net.sf.jasperreports.jdbc.data.adapter.read.only");
    }

    protected Integer getTransactionIsolation(JdbcDataAdapter dataAdapter, JRPropertiesUtil props, JRDataset dataset) {
        TransactionIsolation transactionIsolation = dataAdapter.getTransactionIsolation();
        if (transactionIsolation != null) {
            return transactionIsolation.getLevel();
        }
        String prop = props.getProperty((JRPropertiesHolder)dataset, "net.sf.jasperreports.jdbc.data.adapter.transaction.isolation");
        if (prop != null && !prop.trim().isEmpty()) {
            transactionIsolation = TransactionIsolation.valueOf(prop.trim());
            return transactionIsolation.getLevel();
        }
        return null;
    }

    public String getPassword() throws JRException {
        throw new JRException(EXCEPTION_MESSAGE_KEY_PASSWORD_REQUIRED, (Object[])null);
    }

    @Override
    public void dispose() {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Error while closing the connection.", (Throwable)ex);
                }
            }
        }
    }
}

