/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import net.sf.jasperreports.customvisualization.export.CVElementImageProvider;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.export.GenericElementXlsHandler;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.JRGridLayout;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterContext;
import net.sf.jasperreports.repo.RepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementXlsHandler
implements GenericElementXlsHandler {
    private static final CVElementXlsHandler INSTANCE = new CVElementXlsHandler();
    private static final Log log = LogFactory.getLog(CVElementXlsHandler.class);

    public static CVElementXlsHandler getInstance() {
        return INSTANCE;
    }

    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }

    public void exportElement(JRXlsExporterContext exporterContext, JRGenericPrintElement element, JRExporterGridCell gridCell, int colIndex, int rowIndex, int emptyCols, int yCutsRow, JRGridLayout layout) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting to XLS " + element));
        }
        try {
            RepositoryContext repositoryContext = exporterContext.getRepository().getRepositoryContext();
            JRPrintImage chartImage = CVElementImageProvider.getInstance().getImage(repositoryContext, element);
            JRXlsExporter exporter = (JRXlsExporter)exporterContext.getExporterRef();
            exporter.exportImage(chartImage, gridCell, colIndex, rowIndex, emptyCols, yCutsRow, layout);
        }
        catch (Exception e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }
}

