/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customvisualization.export;

import net.sf.jasperreports.customvisualization.CVPrintElement;
import net.sf.jasperreports.customvisualization.CVUtils;
import net.sf.jasperreports.customvisualization.export.CVElementDefaultImageDataProvider;
import net.sf.jasperreports.customvisualization.export.CVElementImageDataProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleDataRenderer;
import net.sf.jasperreports.renderers.SimpleRenderToImageAwareDataRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CVElementImageProvider {
    private static final Log log = LogFactory.getLog(CVElementImageProvider.class);
    private static final CVElementImageProvider INSTANCE = new CVElementImageProvider();
    private CVElementImageDataProvider cvElementImageDataProvider = new CVElementDefaultImageDataProvider();

    public static CVElementImageProvider getInstance() {
        return INSTANCE;
    }

    public JRPrintImage getImage(RepositoryContext repositoryContext, JRGenericPrintElement element) throws JRException {
        JRPrintImage printImage = this.createPrintImage(element);
        Renderable renderable = this.createRenderable(element, repositoryContext);
        printImage.setRenderer(renderable);
        return printImage;
    }

    public JRPrintImage createPrintImage(JRGenericPrintElement element) {
        JRBasePrintImage printImage = new JRBasePrintImage(element.getDefaultStyleProvider());
        printImage.setUUID(element.getUUID());
        printImage.setX(element.getX());
        printImage.setY(element.getY());
        printImage.setWidth(element.getWidth());
        printImage.setHeight(element.getHeight());
        printImage.setStyle(element.getStyle());
        printImage.setMode(element.getModeValue());
        printImage.setBackcolor(element.getBackcolor());
        printImage.setForecolor(element.getForecolor());
        printImage.setScaleImage(ScaleImageEnum.RETAIN_SHAPE);
        printImage.setHorizontalImageAlign(HorizontalImageAlignEnum.LEFT);
        printImage.setVerticalImageAlign(VerticalImageAlignEnum.TOP);
        return printImage;
    }

    public Renderable createRenderable(JRGenericPrintElement element, RepositoryContext repositoryContext) throws JRException {
        Renderable cacheRenderer = null;
        if (element.getParameterValue("configuration") != null) {
            JasperReportsContext jasperReportsContext = repositoryContext.getJasperReportsContext();
            JRPropertiesUtil propUtil = JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportsContext);
            boolean renderAsPng = CVUtils.isRenderAsPng(element);
            String cacheKey = !renderAsPng ? "cacheRenderer" : "pngCacheRenderer";
            cacheRenderer = (Renderable)element.getParameterValue(cacheKey);
            if (cacheRenderer == null) {
                try {
                    byte[] imageData = this.cvElementImageDataProvider.getImageData(repositoryContext, element);
                    if (renderAsPng) {
                        cacheRenderer = new SimpleDataRenderer(imageData, null);
                    } else {
                        SimpleRenderToImageAwareDataRenderer renderer = new SimpleRenderToImageAwareDataRenderer(imageData, null);
                        renderer.setMinDPI(propUtil.getIntegerProperty((JRPropertiesHolder)element, "com.jaspersoft.jasperreports.components.customvisualization.png.min.dpi", 300));
                        renderer.setAntiAlias(propUtil.getBooleanProperty((JRPropertiesHolder)element, "com.jaspersoft.jasperreports.components.customvisualization.png.antialias", true));
                        cacheRenderer = renderer;
                    }
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Generating image for Custom Visualization element " + CVUtils.getElementId(element) + " failed."), (Throwable)e);
                    }
                    cacheRenderer = RendererUtil.getInstance((JasperReportsContext)jasperReportsContext).handleImageError(e, element.getParameterValue("onErrorType") == null ? CVPrintElement.DEFAULT_ON_ERROR_TYPE : OnErrorTypeEnum.getByName((String)((String)element.getParameterValue("onErrorType"))));
                }
                element.setParameterValue(cacheKey, (Object)cacheRenderer);
            }
        }
        return cacheRenderer;
    }
}

