/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.shape;

import java.awt.Dimension;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import net.sf.jasperreports.charts.JRAbstractChartCustomizer;
import net.sf.jasperreports.customizers.shape.Point;
import net.sf.jasperreports.customizers.shape.ShapePoints;
import net.sf.jasperreports.customizers.shape.ShapeTypeEnum;
import net.sf.jasperreports.customizers.util.ItemsCounter;
import net.sf.jasperreports.customizers.util.SeriesNameProvider;
import org.jfree.chart.plot.XYPlot;

public abstract class AbstractShapeCustomizer
extends JRAbstractChartCustomizer {
    public static final String PROPERTY_SHAPE_WIDTH = "shapeWidth";
    public static final String PROPERTY_SHAPE_HEIGHT = "shapeHeight";
    public static final String PROPERTY_SHAPE_TYPE = "shapeType";
    public static final String PROPERTY_SHAPE_POINTS = "shapePoints";

    protected Integer getWidth() {
        return this.getIntegerProperty(PROPERTY_SHAPE_WIDTH);
    }

    protected Integer getHeight() {
        return this.getIntegerProperty(PROPERTY_SHAPE_HEIGHT);
    }

    protected Shape buildShape() {
        Shape shape = null;
        ShapeTypeEnum shapeType = ShapeTypeEnum.getByName(this.getProperty(PROPERTY_SHAPE_TYPE));
        if (shapeType != null) {
            switch (shapeType) {
                case ELLIPSE: {
                    shape = this.buildEllipse();
                    break;
                }
                case RECTANGLE: {
                    shape = this.buildRectangle();
                    break;
                }
                case POLYLINE: {
                    String shapePoints = this.getProperty(PROPERTY_SHAPE_POINTS);
                    if (shapePoints == null) break;
                    shape = this.buildPolyline(ShapePoints.decode(shapePoints));
                    break;
                }
                case POLYGON: {
                    String shapePoints = this.getProperty(PROPERTY_SHAPE_POINTS);
                    if (shapePoints == null) break;
                    shape = this.buildPolygon(ShapePoints.decode(shapePoints));
                    break;
                }
            }
        }
        return shape;
    }

    protected Dimension2D getSize() {
        Integer width = this.getWidth();
        Integer height = this.getHeight();
        if (width == null && height == null) {
            return null;
        }
        if (width == null) {
            width = height;
        } else if (height == null) {
            height = width;
        }
        return new Dimension(width, height);
    }

    protected Rectangle2D getBounds(ShapePoints shape) {
        Rectangle bounds = null;
        List<Point> points = shape.getPoints();
        if (points != null && !points.isEmpty()) {
            Integer top = null;
            Integer bottom = null;
            Integer left = null;
            Integer right = null;
            for (int i = 0; i < points.size(); ++i) {
                Point point = points.get(i);
                if (top == null || point.getY() < top) {
                    top = point.getY();
                }
                if (bottom == null || point.getY() > bottom) {
                    bottom = point.getY();
                }
                if (left == null || point.getX() < left) {
                    left = point.getX();
                }
                if (right != null && point.getX() <= right) continue;
                right = point.getX();
            }
            bounds = new Rectangle(left, top, right - left, bottom - top);
        }
        return bounds;
    }

    protected abstract Point getOffset(Dimension2D var1);

    protected abstract Point getOffset(Rectangle2D var1);

    protected Shape buildEllipse() {
        Ellipse2D.Float ellipse = null;
        Dimension2D size = this.getSize();
        if (size != null) {
            Point offset = this.getOffset(size);
            ellipse = new Ellipse2D.Float(-offset.getX(), -offset.getY(), (float)size.getWidth(), (float)size.getHeight());
        }
        return ellipse;
    }

    protected Shape buildRectangle() {
        Rectangle2D.Float rectangle = null;
        Dimension2D size = this.getSize();
        if (size != null) {
            Point offset = this.getOffset(size);
            rectangle = new Rectangle2D.Float(-offset.getX(), -offset.getY(), (float)size.getWidth(), (float)size.getHeight());
        }
        return rectangle;
    }

    protected Shape buildPolygon(ShapePoints shapePoints) {
        Polygon polygon = null;
        List<Point> points = shapePoints.getPoints();
        if (points != null && !points.isEmpty()) {
            float scaleFactorX = 1.0f;
            float scaleFactorY = 1.0f;
            Rectangle2D bounds = this.getBounds(shapePoints);
            Integer width = this.getWidth();
            Integer height = this.getHeight();
            if (width != null) {
                scaleFactorX = (float)width.intValue() / (float)bounds.getWidth();
            }
            if (height != null) {
                scaleFactorY = (float)height.intValue() / (float)bounds.getHeight();
            }
            Point offset = this.getOffset(bounds);
            int[] pointsX = new int[points.size()];
            int[] pointsY = new int[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                Point point = points.get(i);
                pointsX[i] = Math.round((float)(point.getX() - offset.getX()) * scaleFactorX);
                pointsY[i] = Math.round((float)(point.getY() - offset.getY()) * scaleFactorY);
            }
            polygon = new Polygon(pointsX, pointsY, points.size());
        }
        return polygon;
    }

    protected Shape buildPolyline(ShapePoints baseShape) {
        Path2D.Double path = null;
        List<Point> points = baseShape.getPoints();
        if (points != null && !points.isEmpty()) {
            float scaleFactorX = 1.0f;
            float scaleFactorY = 1.0f;
            Rectangle2D bounds = this.getBounds(baseShape);
            Integer width = this.getWidth();
            Integer height = this.getHeight();
            if (width != null) {
                scaleFactorX = (float)((double)width.intValue() / bounds.getWidth());
            }
            if (height != null) {
                scaleFactorY = (float)((double)height.intValue() / bounds.getHeight());
            }
            path = new Path2D.Double();
            if (points.size() > 1) {
                Point offset = this.getOffset(bounds);
                Point point = points.get(0);
                ((Path2D)path).moveTo((float)(point.getX() - offset.getX()) * scaleFactorX, (float)(point.getY() - offset.getY()) * scaleFactorY);
                for (int i = 1; i < points.size(); ++i) {
                    point = points.get(i);
                    ((Path2D)path).lineTo((float)(point.getX() - offset.getX()) * scaleFactorX, (float)(point.getY() - offset.getY()) * scaleFactorY);
                }
            }
        }
        return path;
    }

    protected void updateItem(ItemsCounter itemsCounter, ShapeSetter shapeSetter, int index) {
        Shape shape;
        if (index >= 0 && index < itemsCounter.getCount() && (shape = this.buildShape()) != null) {
            shapeSetter.setShape(index, shape);
        }
    }

    protected void updateItems(ItemsCounter itemsCounter, ShapeSetter shapeSetter) {
        Shape shape = this.buildShape();
        if (shape != null) {
            for (int i = 0; i < itemsCounter.getCount(); ++i) {
                shapeSetter.setShape(i, shape);
            }
        }
    }

    protected static interface ShapeSetter {
        public void setShape(int var1, Shape var2);
    }

    class XYPlotSeriesNameProvider
    implements SeriesNameProvider {
        private final XYPlot xyPlot;

        public XYPlotSeriesNameProvider(XYPlot xyPlot) {
            this.xyPlot = xyPlot;
        }

        @Override
        public String getSeriesName(int index) {
            Comparable key = this.xyPlot.getDataset().getSeriesKey(index);
            return key == null ? null : String.valueOf(key);
        }
    }
}

