/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.shape;

import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.customizers.shape.AbstractShapeCustomizer;
import net.sf.jasperreports.customizers.shape.Point;
import net.sf.jasperreports.customizers.util.CategorySeriesNameProvider;
import net.sf.jasperreports.customizers.util.CustomizerUtil;
import net.sf.jasperreports.customizers.util.ItemsCounter;
import net.sf.jasperreports.customizers.util.SeriesNameProvider;
import net.sf.jasperreports.engine.JRChart;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class LegendShapeCustomizer
extends AbstractShapeCustomizer {
    public void customize(JFreeChart jfc, JRChart jrc) {
        Plot plot = jfc.getPlot();
        LegendItemsCounter itemsCounter = new LegendItemsCounter(plot);
        SeriesNameProvider seriesNameProvider = null;
        XYItemRenderer renderer = null;
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = jfc.getXYPlot();
            renderer = xyPlot.getRenderer();
            seriesNameProvider = new AbstractShapeCustomizer.XYPlotSeriesNameProvider(this, xyPlot);
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = jfc.getCategoryPlot();
            renderer = categoryPlot.getRenderer();
            seriesNameProvider = new CategorySeriesNameProvider(categoryPlot);
        }
        Integer legendItemIndex = CustomizerUtil.resolveIndex(this, itemsCounter, seriesNameProvider);
        if (legendItemIndex != null && renderer instanceof AbstractRenderer) {
            AbstractRendererLegendShapeSetter shapeSetter = new AbstractRendererLegendShapeSetter((AbstractRenderer)renderer);
            if (legendItemIndex == -1) {
                this.updateItems(itemsCounter, shapeSetter);
            } else {
                this.updateItem(itemsCounter, shapeSetter, legendItemIndex);
            }
        }
    }

    @Override
    protected Point getOffset(Dimension2D size) {
        return new Point(0, 0);
    }

    @Override
    protected Point getOffset(Rectangle2D bounds) {
        return new Point(0, 0);
    }

    class LegendItemsCounter
    implements ItemsCounter {
        private final Plot plot;

        public LegendItemsCounter(Plot plot) {
            this.plot = plot;
        }

        @Override
        public int getCount() {
            return this.plot.getLegendItems().getItemCount();
        }
    }

    protected class AbstractRendererLegendShapeSetter
    implements AbstractShapeCustomizer.ShapeSetter {
        private final AbstractRenderer renderer;

        public AbstractRendererLegendShapeSetter(AbstractRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public void setShape(int seriesIndex, Shape shape) {
            this.renderer.setLegendShape(seriesIndex, shape);
        }
    }
}

