/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.marker;

import java.awt.Font;
import net.sf.jasperreports.customizers.marker.AbstractMarkerCustomizer;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fonts.FontUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;

public class CategoryMarkerCustomizer
extends AbstractMarkerCustomizer {
    public static final String PROPERTY_CATEGORY = "category";
    public static final String PROPERTY_FONT_NAME = "fontName";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_FONT_BOLD = "isBold";
    public static final String PROPERTY_FONT_ITALIC = "isItalic";
    public static String PROPERTY_DRAW_AS_LINE = "drawAsLine";

    public void customize(JFreeChart jfc, JRChart jrc) {
        CategoryMarker marker;
        Plot plot = jfc.getPlot();
        if (plot instanceof CategoryPlot && ((CategoryPlot)plot).getDataset() != null && (marker = this.createMarker(jrc)) != null) {
            this.addMarker(plot, (Marker)marker);
        }
    }

    protected CategoryMarker createMarker(JRChart jrc) {
        Boolean isItalic;
        Float fontSize;
        String value = this.getProperty(PROPERTY_CATEGORY);
        if (value == null) {
            return null;
        }
        CategoryMarker marker = new CategoryMarker((Comparable)((Object)value));
        this.configureMarker((Marker)marker);
        this.configureStroke((Marker)marker);
        Boolean drawAsLine = this.getBooleanProperty(PROPERTY_DRAW_AS_LINE);
        if (drawAsLine != null) {
            marker.setDrawAsLine(drawAsLine.booleanValue());
        }
        Font font = marker.getLabelFont();
        String fontName = this.getProperty(PROPERTY_FONT_NAME);
        if (fontName == null) {
            fontName = font.getName();
        }
        if ((fontSize = this.getFloatProperty(PROPERTY_FONT_SIZE)) == null) {
            fontSize = Float.valueOf(font.getSize());
        }
        int fontStyle = 0;
        Boolean isBold = this.getBooleanProperty(PROPERTY_FONT_BOLD);
        if (isBold != null) {
            fontStyle |= 1;
        }
        if ((isItalic = this.getBooleanProperty(PROPERTY_FONT_ITALIC)) != null) {
            fontStyle |= 2;
        }
        marker.setLabelFont(FontUtil.getInstance((JasperReportsContext)this.filler.getJasperReportsContext()).getAwtFontFromBundles(fontName, fontStyle, fontSize.floatValue(), this.filler.getFillContext().getMasterLocale(), true));
        return marker;
    }

    @Override
    protected void addMarker(Plot plot, Marker marker) {
        ((CategoryPlot)plot).addDomainMarker((CategoryMarker)marker, this.getLayer());
    }
}

