/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.marker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import net.sf.jasperreports.customizers.marker.AbstractMarkerCustomizer;
import net.sf.jasperreports.engine.util.JRColorUtil;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;

public abstract class AbstractIntervalMarkerCustomizer
extends AbstractMarkerCustomizer {
    public static final String PROPERTY_START_VALUE = "startValue";
    public static final String PROPERTY_END_VALUE = "endValue";
    public static final String PROPERTY_OUTLINE_COLOR = "outlineColor";

    protected IntervalMarker createMarker() {
        Double startValue = this.getDoubleProperty(PROPERTY_START_VALUE);
        Double endValue = this.getDoubleProperty(PROPERTY_END_VALUE);
        if (startValue == null || endValue == null) {
            return null;
        }
        IntervalMarker marker = new IntervalMarker(startValue.doubleValue(), endValue.doubleValue());
        this.configureMarker((Marker)marker);
        Float strokeWidth = this.getFloatProperty("strokeWidth");
        if (strokeWidth != null && strokeWidth.floatValue() > 0.0f) {
            BasicStroke basicStroke = this.getStroke(strokeWidth);
            marker.setOutlineStroke((Stroke)basicStroke);
            Color outlineColor = JRColorUtil.getColor((String)this.getProperty(PROPERTY_OUTLINE_COLOR), null);
            if (outlineColor != null) {
                marker.setOutlinePaint((Paint)outlineColor);
            }
        }
        return marker;
    }
}

