/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.barcode4j;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.barcode4j.Barcode4jComponent;
import net.sf.jasperreports.barcode4j.BarcodeImageProducer;
import net.sf.jasperreports.barcode4j.OrientationEnum;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.SimpleRenderToImageAwareDataRenderer;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.w3c.dom.Document;

public class BarcodeSVGImageProducer
implements BarcodeImageProducer {
    @Override
    public Renderable createImage(JasperReportsContext jasperReportsContext, JRComponentElement componentElement, BarcodeGenerator barcode, String message) {
        try {
            SVGCanvasProvider provider = new SVGCanvasProvider(false, OrientationEnum.getValueOrDefault(((Barcode4jComponent)componentElement.getComponent()).getOrientation()).getValue().intValue());
            barcode.generateBarcode((CanvasProvider)provider, message);
            Document svgDoc = provider.getDOM();
            DOMSource source = new DOMSource(svgDoc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult output = new StreamResult(baos);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, output);
            return SimpleRenderToImageAwareDataRenderer.getInstance((byte[])baos.toByteArray());
        }
        catch (Exception e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }
}

