/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;

public class SumAggregator
extends Aggregator {
    private DoubleDouble mySum = new DoubleDouble();

    public SumAggregator(String property) {
        this.setProperty(property);
    }

    public SumAggregator replicate() {
        return new SumAggregator(this.getProperty());
    }

    public void init() {
        this.mySum.reset();
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)SumAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    this.mySum.addToSelf(obj.doubleValue());
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof SumAggregator) {
            SumAggregator otherAgg = (SumAggregator)agg;
            this.mySum.addToSelf(otherAgg.mySum);
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        return new DoubleDouble(this.mySum);
    }
}

