/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

public class PropertyScanner {
    private static final String PUNCT_CHARS_NOT_AS_STRING = "\"'(),";
    private String myPropertyText;
    private int myOffset;
    private boolean amIInsideDoubleQuotes;
    private boolean amIInsideSingleQuotes;
    private String myCurrLexeme;

    public PropertyScanner() {
        this("");
    }

    public PropertyScanner(String propertyText) {
        this.setPropertyText(propertyText);
    }

    public Token getNextToken() {
        int iStartOfToken = this.myOffset;
        int iTokenLength = 0;
        Token tokenType = Token.TOKEN_UNKNOWN;
        if (this.amIInsideDoubleQuotes) {
            if (iStartOfToken >= this.myPropertyText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_DQUOTES;
            } else if (this.myPropertyText.charAt(iStartOfToken) == '\"') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_DOUBLE_QUOTE;
                this.amIInsideDoubleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myPropertyText.length() && this.myPropertyText.charAt(iStartOfToken + iTokenLength) != '\"') {
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (this.amIInsideSingleQuotes) {
            if (iStartOfToken >= this.myPropertyText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_SQUOTES;
            } else if (this.myPropertyText.charAt(iStartOfToken) == '\'') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_SINGLE_QUOTE;
                this.amIInsideSingleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myPropertyText.length() && this.myPropertyText.charAt(iStartOfToken + iTokenLength) != '\'') {
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (iStartOfToken >= this.myPropertyText.length()) {
            iTokenLength = 0;
            tokenType = Token.TOKEN_EOI;
        } else if (iStartOfToken + iTokenLength < this.myPropertyText.length() && !Character.isWhitespace(this.myPropertyText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myPropertyText.charAt(iStartOfToken + iTokenLength)) == -1) {
            while (iStartOfToken + iTokenLength < this.myPropertyText.length() && !Character.isWhitespace(this.myPropertyText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myPropertyText.charAt(iStartOfToken + iTokenLength)) == -1) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_STRING;
        } else if (this.myPropertyText.charAt(iStartOfToken) == ',') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_COMMA;
        } else if (this.myPropertyText.charAt(iStartOfToken) == '\"') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_DOUBLE_QUOTE;
            this.amIInsideDoubleQuotes = true;
        } else if (this.myPropertyText.charAt(iStartOfToken) == '\'') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_SINGLE_QUOTE;
            this.amIInsideSingleQuotes = true;
        } else if (this.myPropertyText.charAt(iStartOfToken) == '(') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_LEFT_PAREN;
        } else if (this.myPropertyText.charAt(iStartOfToken) == ')') {
            tokenType = Token.TOKEN_RIGHT_PAREN;
            iTokenLength = 1;
        } else if (Character.isWhitespace(this.myPropertyText.charAt(iStartOfToken))) {
            while (iStartOfToken + iTokenLength < this.myPropertyText.length() && Character.isWhitespace(this.myPropertyText.charAt(iStartOfToken + iTokenLength))) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_WHITESPACE;
        }
        this.myCurrLexeme = this.myPropertyText.substring(iStartOfToken, iStartOfToken + iTokenLength);
        this.myOffset += iTokenLength;
        return tokenType;
    }

    public String getCurrLexeme() {
        return this.myCurrLexeme;
    }

    public void reset() {
        this.myOffset = 0;
        this.amIInsideDoubleQuotes = false;
        this.amIInsideSingleQuotes = false;
        this.myCurrLexeme = null;
    }

    public void setPropertyText(String propertyText) {
        this.myPropertyText = propertyText;
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        TOKEN_ERROR_EOI_IN_SQUOTES(-4),
        TOKEN_ERROR_EOI_IN_DQUOTES(-3),
        TOKEN_ERROR_BUF_NULL(-2),
        TOKEN_UNKNOWN(-1),
        TOKEN_WHITESPACE(0),
        TOKEN_STRING(1),
        TOKEN_COMMA(11),
        TOKEN_DOUBLE_QUOTE(12),
        TOKEN_SINGLE_QUOTE(13),
        TOKEN_LEFT_PAREN(14),
        TOKEN_RIGHT_PAREN(15),
        TOKEN_EOI(99);

        private int myCode;

        private Token(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }
}

