/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.PropertyScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyParser {
    private static final boolean DEBUG = false;
    private String myPropertyText;
    private String myPropertyName;
    private boolean amIMethod;
    private List<Object> myParameters = new ArrayList<Object>();

    public PropertyParser() {
        this.setPropertyText("");
    }

    public PropertyParser(String propertyText) {
        this.setPropertyText(propertyText);
    }

    public void setPropertyText(String propertyText) {
        this.myPropertyText = propertyText;
        this.reset();
    }

    private void reset() {
        this.myPropertyName = null;
        this.amIMethod = false;
        this.myParameters.clear();
    }

    public void parse() {
        PropertyScanner scanner = new PropertyScanner(this.myPropertyText);
        String lexeme = "";
        boolean wasQuoted = false;
        PropertyScanner.Token token = scanner.getNextToken();
        if (token == PropertyScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        if (token != PropertyScanner.Token.TOKEN_STRING) {
            throw new IllegalArgumentException("Illegal start to property or method name: \"" + this.myPropertyText + "\".");
        }
        this.myPropertyName = scanner.getCurrLexeme();
        token = scanner.getNextToken();
        if (token == PropertyScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        if (token == PropertyScanner.Token.TOKEN_EOI) {
            this.amIMethod = false;
            return;
        }
        if (token != PropertyScanner.Token.TOKEN_LEFT_PAREN) {
            throw new IllegalArgumentException("Property or method name must start with '(': \"" + this.myPropertyText + "\".");
        }
        this.amIMethod = true;
        token = scanner.getNextToken();
        while (token.getCode() >= 0 && token != PropertyScanner.Token.TOKEN_RIGHT_PAREN) {
            switch (token) {
                case TOKEN_WHITESPACE: {
                    break;
                }
                case TOKEN_STRING: {
                    lexeme = scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_COMMA: {
                    if (wasQuoted || lexeme.length() > 0) {
                        this.myParameters.add(this.getTypedParameter(lexeme, wasQuoted));
                    }
                    wasQuoted = false;
                    break;
                }
                case TOKEN_DOUBLE_QUOTE: {
                    wasQuoted = true;
                    break;
                }
                case TOKEN_SINGLE_QUOTE: {
                    wasQuoted = true;
                    break;
                }
                case TOKEN_EOI: {
                    throw new IllegalArgumentException("'(' found without ')': \"" + this.myPropertyText + "\".");
                }
                default: {
                    throw new IllegalArgumentException("Parse error occurred: \"" + this.myPropertyText + "\".");
                }
            }
            token = scanner.getNextToken();
        }
        if (token.getCode() < 0) {
            throw new IllegalArgumentException("A parse error occured: \"" + this.myPropertyText + "\".");
        }
        if (wasQuoted || lexeme.length() > 0) {
            Object value = this.getTypedParameter(lexeme, wasQuoted);
            this.myParameters.add(value);
        }
        if ((token = scanner.getNextToken()) == PropertyScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        if (token != PropertyScanner.Token.TOKEN_EOI) {
            throw new IllegalArgumentException("Extra input found after ')': \"" + this.myPropertyText + "\".");
        }
    }

    private Object getTypedParameter(String parameter, boolean wasQuoted) {
        if (wasQuoted) {
            if (parameter == null || parameter.length() == 0) {
                return "";
            }
            return parameter;
        }
        if (parameter.matches(".*[A-Za-z]+.*")) {
            if ("true".equalsIgnoreCase(parameter)) {
                return true;
            }
            if ("false".equalsIgnoreCase(parameter)) {
                return false;
            }
            if ("null".equalsIgnoreCase(parameter)) {
                return null;
            }
            if (parameter.contains(":")) {
                int index = parameter.indexOf(":");
                String className = parameter.substring(0, index);
                String enumName = parameter.substring(index + 1);
                try {
                    Class<?> enumClass = Class.forName(className);
                    return Enum.valueOf(enumClass, enumName);
                }
                catch (ClassNotFoundException e) {
                    throw new UnsupportedOperationException("Unrecognized Enum: \"" + className + "\"", e);
                }
                catch (ClassCastException e) {
                    throw new UnsupportedOperationException("Not an Enum: \"" + className + "\"", e);
                }
            }
            return parameter;
        }
        if (parameter.matches("[-]?[0-9]+\\.[0-9]*")) {
            try {
                Double result = Double.valueOf(parameter);
                return result;
            }
            catch (NumberFormatException ignored) {
                try {
                    BigDecimal result = new BigDecimal(parameter);
                    return result;
                }
                catch (NumberFormatException ignored2) {
                    return parameter;
                }
            }
        }
        if (parameter.matches("[-]?[0-9]+")) {
            try {
                Byte result = Byte.valueOf(parameter);
                return result;
            }
            catch (NumberFormatException ignored) {
                try {
                    Short result = Short.valueOf(parameter);
                    return result;
                }
                catch (NumberFormatException ignored3) {
                    try {
                        Integer result = Integer.valueOf(parameter);
                        return result;
                    }
                    catch (NumberFormatException ignored4) {
                        try {
                            Long result = Long.valueOf(parameter);
                            return result;
                        }
                        catch (NumberFormatException ignored5) {
                            try {
                                BigInteger result = new BigInteger(parameter);
                                return result;
                            }
                            catch (NumberFormatException ignored6) {
                                return parameter;
                            }
                        }
                    }
                }
            }
        }
        return parameter;
    }

    public String getPropertyName() {
        return this.myPropertyName;
    }

    public boolean isMethod() {
        return this.amIMethod;
    }

    public List<Object> getParameters() {
        if (!this.amIMethod) {
            return null;
        }
        return this.myParameters;
    }
}

