/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;

public class ProductAggregator
extends Aggregator {
    private DoubleDouble myProduct = new DoubleDouble();

    public ProductAggregator(String property) {
        this.setProperty(property);
    }

    public ProductAggregator replicate() {
        return new ProductAggregator(this.getProperty());
    }

    public void init() {
        this.myProduct.reset();
        this.myProduct.addToSelf(1.0);
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)ProductAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    this.myProduct.multiplySelfBy(obj.doubleValue());
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof ProductAggregator) {
            ProductAggregator otherAgg = (ProductAggregator)agg;
            this.myProduct.multiplySelfBy(otherAgg.myProduct);
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        return new DoubleDouble(this.myProduct);
    }
}

