/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;
import net.sf.jagg.PropertiesComparator;
import net.sf.jagg.TwoPropAggregator;

public class PercentileAggregator
extends TwoPropAggregator {
    private List<Object> myRecords;
    private double myPercentile;

    public PercentileAggregator(String properties) {
        this.setProperty(properties);
    }

    public PercentileAggregator(double percentile, String property) {
        this.setProperty("" + percentile + "," + property);
    }

    public PercentileAggregator replicate() {
        return new PercentileAggregator(this.myPercentile, this.getProperty2());
    }

    protected void setProperty(String property) {
        super.setProperty(property);
        this.myPercentile = Double.parseDouble(this.getProperty());
        if (this.myPercentile < 0.0 || this.myPercentile > 1.0) {
            throw new IllegalArgumentException("First property (percentile) must be between 0 and 1 inclusive: " + this.myPercentile);
        }
        if (this.getProperty2() == null) {
            throw new IllegalArgumentException("Second property (sort parameter) must not be null.");
        }
    }

    public void init() {
        this.myRecords = new ArrayList<Object>();
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty2();
            try {
                Number obj = (Number)PercentileAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    this.myRecords.add(value);
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof PercentileAggregator) {
            PercentileAggregator otherAgg = (PercentileAggregator)agg;
            this.myRecords.addAll(otherAgg.myRecords);
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        int numItems = this.myRecords.size();
        DoubleDouble rownum = new DoubleDouble(this.myPercentile);
        rownum.multiplySelfBy(numItems - 1);
        double floor = Math.floor(rownum.doubleValue());
        double ceiling = Math.ceil(rownum.doubleValue());
        if (numItems == 0) {
            return new DoubleDouble(DoubleDouble.NaN);
        }
        ArrayList<String> sortProperties = new ArrayList<String>();
        sortProperties.add(this.getProperty2());
        PropertiesComparator comparator = new PropertiesComparator(sortProperties);
        Collections.sort(this.myRecords, comparator);
        if (rownum.doubleValue() == floor && rownum.doubleValue() == ceiling) {
            String property = null;
            Object value = this.myRecords.get((int)floor);
            try {
                property = this.getProperty2();
                Number obj = (Number)PercentileAggregator.getValueFromProperty(value, property);
                return new DoubleDouble(obj.doubleValue());
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
        String property = null;
        Object lowValue = this.myRecords.get((int)floor);
        Object highValue = this.myRecords.get((int)ceiling);
        try {
            property = this.getProperty2();
            Number obj1 = (Number)PercentileAggregator.getValueFromProperty(lowValue, property);
            Number obj2 = (Number)PercentileAggregator.getValueFromProperty(highValue, property);
            DoubleDouble low = new DoubleDouble(obj1.doubleValue());
            DoubleDouble high = new DoubleDouble(obj2.doubleValue());
            DoubleDouble temp = new DoubleDouble(rownum);
            temp.subtractFromSelf(floor);
            temp.multiplySelfBy(high);
            DoubleDouble temp2 = new DoubleDouble(rownum);
            temp2.negateSelf();
            temp2.addToSelf(ceiling);
            temp2.multiplySelfBy(low);
            temp2.addToSelf(temp);
            return temp2;
        }
        catch (ClassCastException e) {
            throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
        }
    }
}

