/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jagg.Aggregator;

public class ModeAggregator
extends Aggregator {
    private List<Comparable> myRecords;

    public ModeAggregator(String property) {
        this.setProperty(property);
    }

    public ModeAggregator replicate() {
        return new ModeAggregator(this.getProperty());
    }

    public void init() {
        this.myRecords = new ArrayList<Comparable>();
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable comp = (Comparable)ModeAggregator.getValueFromProperty(value, property);
                if (comp != null) {
                    this.myRecords.add(comp);
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof ModeAggregator) {
            ModeAggregator otherAgg = (ModeAggregator)agg;
            this.myRecords.addAll(otherAgg.myRecords);
        }
    }

    public Comparable terminate() {
        int numItems = this.myRecords.size();
        if (numItems == 0) {
            return null;
        }
        Collections.sort(this.myRecords);
        Comparable mode = null;
        Comparable prev = null;
        int frequency = 0;
        int maxFrequency = 0;
        for (int i = 0; i < numItems; ++i) {
            Comparable c = this.myRecords.get(i);
            if (prev != null && c.compareTo(prev) == 0) {
                ++frequency;
                continue;
            }
            if (frequency > maxFrequency) {
                maxFrequency = frequency;
                mode = prev;
            }
            frequency = 1;
            prev = c;
        }
        if (frequency > maxFrequency) {
            mode = prev;
        }
        return mode;
    }
}

