/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jagg.MethodCall;
import net.sf.jagg.PropertyParser;
import net.sf.jagg.SelfMethodCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCache {
    private static final boolean DEBUG = false;
    private static MethodCache theMethodCache = null;
    private final HashMap<String, MethodCall> myMethods = new HashMap();

    private MethodCache() {
    }

    public static MethodCache getMethodCache() {
        if (theMethodCache == null) {
            theMethodCache = new MethodCache();
        }
        return theMethodCache;
    }

    public Object getValueFromProperty(Object value, String property) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (".".equals(property)) {
            return value;
        }
        MethodCall methodCall = this.getMethodCallFromProperty(value, property);
        return methodCall.invoke(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MethodCall getMethodCallFromProperty(Object value, String property) throws NoSuchMethodException {
        String lookup = value.getClass().getName() + "." + property;
        HashMap<String, MethodCall> hashMap = this.myMethods;
        synchronized (hashMap) {
            MethodCall methodCall = this.myMethods.get(lookup);
            if (methodCall != null) return methodCall;
            if (".".equals(property)) {
                methodCall = new SelfMethodCall(value);
            } else {
                Method method;
                Object[] parameterArray;
                PropertyParser parser = new PropertyParser(property);
                parser.parse();
                if (parser.isMethod()) {
                    String methodName = parser.getPropertyName();
                    List<Object> parameters = parser.getParameters();
                    Class[] classes = new Class[parameters.size()];
                    for (int i = 0; i < parameters.size(); ++i) {
                        Class<?> theClass;
                        classes[i] = theClass = parameters.get(i).getClass();
                    }
                    parameterArray = parameters.toArray();
                    try {
                        method = value.getClass().getMethod(methodName, classes);
                    }
                    catch (NoSuchMethodException e) {
                        method = this.findMethod(value.getClass(), methodName, classes);
                    }
                    if (method == null) throw new NoSuchMethodException("Couldn't find Method: " + methodName);
                    this.assignParameters(method.getParameterTypes(), parameterArray);
                } else {
                    try {
                        String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
                        method = value.getClass().getMethod(methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            String methodName = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
                            method = value.getClass().getMethod(methodName, new Class[0]);
                        }
                        catch (NoSuchMethodException e2) {
                            throw new NoSuchMethodException("No matching method found for property \"" + property + "\"");
                        }
                    }
                    parameterArray = new Object[]{};
                }
                methodCall = new MethodCall(method, parameterArray);
            }
            this.myMethods.put(lookup, methodCall);
            return methodCall;
        }
    }

    private Method findMethod(Class<?> theClass, String methodName, Class<?>[] paramTypes) {
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] allMethods = theClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method method = allMethods[i];
            if (!methodName.equals(method.getName()) || !this.doesMethodApply(method, paramTypes)) continue;
            methods.add(method);
        }
        int size = methods.size();
        if (size == 1) {
            return (Method)methods.get(0);
        }
        if (size == 0) {
            return null;
        }
        Method mostSpecific = null;
        for (int i = 0; i < size; ++i) {
            Method method = (Method)methods.get(i);
            if (mostSpecific != null && !this.isMoreSpecific(method.getParameterTypes(), mostSpecific.getParameterTypes())) continue;
            mostSpecific = method;
        }
        return mostSpecific;
    }

    private void assignParameters(Class<?>[] desiredTypes, Object[] values) {
        for (int i = 0; i < desiredTypes.length; ++i) {
            Class<?> desiredType = desiredTypes[i];
            Class<?> valueType = values[i].getClass();
            if (desiredType == valueType) continue;
            if (!desiredType.isPrimitive()) {
                values[i] = desiredType.cast(values[i]);
                continue;
            }
            if (desiredType == Short.TYPE || desiredType == Short.class) {
                values[i] = ((Number)values[i]).shortValue();
                continue;
            }
            if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                values[i] = ((Number)values[i]).intValue();
                continue;
            }
            if (desiredType == Long.TYPE || desiredType == Long.class) {
                values[i] = ((Number)values[i]).longValue();
                continue;
            }
            if (desiredType == Float.TYPE || desiredType == Float.class) {
                values[i] = Float.valueOf(((Number)values[i]).floatValue());
                continue;
            }
            if (desiredType != Double.TYPE && desiredType != Double.class) continue;
            values[i] = ((Number)values[i]).doubleValue();
        }
    }

    private boolean isMoreSpecific(Class<?>[] types1, Class<?>[] types2) {
        for (int i = 0; i < types1.length; ++i) {
            boolean leftParamAssignableToRight = this.isAssignable(types1[i], types2[i]);
            boolean rightParamAssignableToLeft = this.isAssignable(types2[i], types1[i]);
            if (leftParamAssignableToRight) {
                if (rightParamAssignableToLeft) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean doesMethodApply(Method method, Class<?>[] paramTypes) {
        Class<?>[] methodParamTypes = method.getParameterTypes();
        if (methodParamTypes.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < methodParamTypes.length; ++i) {
            if (this.isAssignable(paramTypes[i], methodParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(Class<?> fromClass, Class<?> toClass) {
        if (!toClass.isPrimitive() && toClass.isAssignableFrom(fromClass)) {
            return true;
        }
        if (toClass.isPrimitive()) {
            if (toClass == Boolean.TYPE && fromClass == Boolean.class) {
                return true;
            }
            if (toClass == Byte.TYPE && fromClass == Byte.class) {
                return true;
            }
            if (toClass == Short.TYPE && (fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Integer.TYPE && (fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Long.TYPE && (fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Float.TYPE && (fromClass == Float.class || fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Float.TYPE && (fromClass == Double.class || fromClass == Float.class || fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
            if (toClass == Double.TYPE && (fromClass == Double.class || fromClass == Float.class || fromClass == Long.class || fromClass == Integer.class || fromClass == Short.class || fromClass == Byte.class)) {
                return true;
            }
        }
        return false;
    }
}

