/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;

public class CountAggregator
extends Aggregator {
    public static final String COUNT_ALL = "*";
    private long myCount;

    public CountAggregator(String property) {
        this.setProperty(property);
    }

    public CountAggregator replicate() {
        return new CountAggregator(this.getProperty());
    }

    public void init() {
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            if (property.equals(COUNT_ALL)) {
                ++this.myCount;
            } else {
                Object obj = CountAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                }
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof CountAggregator) {
            CountAggregator otherAgg = (CountAggregator)agg;
            this.myCount += otherAgg.myCount;
        }
    }

    public Long terminate() {
        return this.myCount;
    }
}

