/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.CovariancePopAggregator;
import net.sf.jagg.DoubleDouble;
import net.sf.jagg.TwoPropAggregator;
import net.sf.jagg.VariancePopAggregator;

public class CorrelationAggregator
extends TwoPropAggregator {
    private CovariancePopAggregator myCovarianceAgg = null;
    private VariancePopAggregator myFirstVarAgg = null;
    private VariancePopAggregator mySecondVarAgg = null;

    public CorrelationAggregator(String properties) {
        this.setProperty(properties);
    }

    public CorrelationAggregator(String property, String property2) {
        this.setProperty(property + "," + property2);
    }

    public CorrelationAggregator replicate() {
        return new CorrelationAggregator(this.getProperty(), this.getProperty2());
    }

    public void init() {
        if (this.myCovarianceAgg == null) {
            this.myCovarianceAgg = new CovariancePopAggregator(this.getProperty(), this.getProperty2());
        }
        if (this.myFirstVarAgg == null) {
            this.myFirstVarAgg = new VariancePopAggregator(this.getProperty());
        }
        if (this.mySecondVarAgg == null) {
            this.mySecondVarAgg = new VariancePopAggregator(this.getProperty2());
        }
        this.myCovarianceAgg.init();
        this.myFirstVarAgg.init();
        this.mySecondVarAgg.init();
    }

    public void iterate(Object value) {
        this.myCovarianceAgg.iterate(value);
        this.myFirstVarAgg.iterate(value);
        this.mySecondVarAgg.iterate(value);
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof CorrelationAggregator) {
            CorrelationAggregator otherAgg = (CorrelationAggregator)agg;
            this.myCovarianceAgg.merge(otherAgg.myCovarianceAgg);
            this.myFirstVarAgg.merge(otherAgg.myFirstVarAgg);
            this.mySecondVarAgg.merge(otherAgg.mySecondVarAgg);
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        DoubleDouble covariance = this.myCovarianceAgg.terminateDoubleDouble();
        DoubleDouble variance1 = this.myFirstVarAgg.terminateDoubleDouble();
        DoubleDouble variance2 = this.mySecondVarAgg.terminateDoubleDouble();
        if (covariance.isNaN() || variance1.isNaN() || variance2.isNaN()) {
            return new DoubleDouble(DoubleDouble.NaN);
        }
        if (variance1.compareTo(DoubleDouble.ZERO) == 0 || variance2.compareTo(DoubleDouble.ZERO) == 0) {
            return new DoubleDouble(DoubleDouble.NaN);
        }
        variance1.multiplySelfBy(variance2);
        variance1.sqrtSelf();
        covariance.divideSelfBy(variance1);
        return covariance;
    }
}

