/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.sf.jagg.AggregatorCache;
import net.sf.jagg.DoubleDouble;
import net.sf.jagg.MethodCache;

public abstract class Aggregator {
    public static final String PROP_SELF = ".";
    private static final MethodCache myMethodCache = MethodCache.getMethodCache();
    private static final AggregatorCache myAggregatorCache = AggregatorCache.getAggregatorCache();
    private String myProperty;
    private boolean amIInUse = false;

    protected Aggregator() {
    }

    public static Aggregator getAggregator(Aggregator archetype) {
        return myAggregatorCache.getAggregator(archetype);
    }

    public static Aggregator getAggregator(String aggSpec) {
        int leftParenIdx = aggSpec.indexOf("(");
        int rightParenIdx = aggSpec.lastIndexOf(")");
        if (leftParenIdx == -1 || rightParenIdx == -1 || leftParenIdx > rightParenIdx) {
            throw new IllegalArgumentException("Malformed Aggregator specification: " + aggSpec);
        }
        String aggName = aggSpec.substring(0, leftParenIdx);
        if (aggName.indexOf(PROP_SELF) == -1) {
            aggName = Aggregator.class.getPackage().getName() + PROP_SELF + aggName;
        }
        if (!aggName.endsWith("Aggregator")) {
            aggName = aggName + "Aggregator";
        }
        String property = aggSpec.substring(leftParenIdx + 1, rightParenIdx);
        try {
            Class<?> aggClass = Class.forName(aggName);
            Constructor<?> ctor = aggClass.getConstructor(String.class);
            return (Aggregator)ctor.newInstance(property);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown Aggregator class \"" + aggName + "\".", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor for Aggregator class \"" + aggName + "\" that contains exactly one String parameter.", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Aggregator specified is not a concreted class: \"" + aggName + "\".", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to constructor Aggregator \"" + aggName + "\".", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Exception caught instantiating Aggregator \"" + aggName + "\": " + e.getCause().getClass().getName(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Class found is not an Aggregator: \"" + aggName + "\".", e);
        }
    }

    public static Object getValueFromProperty(Object value, String property) {
        try {
            return myMethodCache.getValueFromProperty(value, property);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException("No matching method found for \"" + property + "\".", e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException("Illegal method access detected for property \"" + property + "\".", e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException("Exception detected getting property \"" + property + "\".", e);
        }
    }

    protected void setProperty(String property) {
        this.myProperty = property;
    }

    public final boolean isInUse() {
        return this.amIInUse;
    }

    public final void setInUse(boolean inUse) {
        this.amIInUse = inUse;
    }

    public abstract Aggregator replicate();

    public abstract void init();

    public abstract void iterate(Object var1);

    public abstract void merge(Aggregator var1);

    public abstract Object terminate();

    public DoubleDouble terminateDoubleDouble() {
        return DoubleDouble.NaN;
    }

    public boolean equals(Object o) {
        return this.getClass().equals(o.getClass()) && this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getProperty() {
        return this.myProperty;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getProperty() + ")";
    }
}

