/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.jagg.AggregateValue;
import net.sf.jagg.Aggregation;
import net.sf.jagg.Aggregator;
import net.sf.jagg.PositionedAggregatorList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregations {
    private Aggregations() {
    }

    public static <T extends Comparable<? super T>> List<AggregateValue<T>> groupBy(List<T> values, List<Aggregator> aggregators) {
        return new Aggregation.Builder().setAggregators(aggregators).build().groupByComparable(values);
    }

    public static <T extends Comparable<? super T>> List<AggregateValue<T>> groupBy(List<T> values, List<Aggregator> aggregators, int parallelism) {
        return new Aggregation.Builder().setAggregators(aggregators).setParallelism(parallelism).build().groupByComparable(values);
    }

    public static <T> List<AggregateValue<T>> groupBy(List<T> values, List<String> properties, List<Aggregator> aggregators) {
        return new Aggregation.Builder().setAggregators(aggregators).setProperties(properties).build().groupBy(values);
    }

    public static <T> List<AggregateValue<T>> groupBy(List<T> values, List<String> properties, List<Aggregator> aggregators, boolean useMsd) {
        return new Aggregation.Builder().setAggregators(aggregators).setProperties(properties).setUseMsd(useMsd).build().groupBy(values);
    }

    public static <T> List<AggregateValue<T>> groupBy(List<T> values, List<String> properties, List<Aggregator> aggregators, int parallelism) {
        return new Aggregation.Builder().setAggregators(aggregators).setProperties(properties).setParallelism(parallelism).build().groupBy(values);
    }

    public static <T> List<AggregateValue<T>> groupBy(List<T> values, List<String> properties, List<Aggregator> aggregators, int parallelism, boolean useMsd) {
        return new Aggregation.Builder().setAggregators(aggregators).setProperties(properties).setParallelism(parallelism).setUseMsd(useMsd).build().groupBy(values);
    }

    public static <T> List<AggregateValue<T>> mergeLists(List<PositionedAggregatorList<T>> listOfPals, Comparator<? super T> comparator, boolean useSuperAggregation, List<String> properties) {
        List<Aggregator> prevAggsList;
        T prevObject;
        int numProperties = properties != null ? properties.size() : 0;
        ArrayList<Integer> defaultGroupingSet = new ArrayList<Integer>(numProperties);
        for (int i = 0; i < numProperties; ++i) {
            defaultGroupingSet.add(i);
        }
        ArrayList<AggregateValue<T>> aggValues = new ArrayList<AggregateValue<T>>();
        PositionedAggregatorList<T> prev = listOfPals.get(0);
        if (prev.getEndingAggList() == null) {
            prevObject = prev.getInitialObject();
            prevAggsList = prev.getInitialAggList();
        } else {
            List<Aggregator> aggs = prev.getInitialAggList();
            int aggSize = aggs.size();
            T initObject = prev.getInitialObject();
            AggregateValue<T> firstValue = new AggregateValue<T>(initObject);
            for (int a = 0; a < aggSize; ++a) {
                Aggregator agg = aggs.get(a);
                firstValue.setAggregateValue(agg, agg.terminate());
                if (useSuperAggregation) continue;
                agg.setInUse(false);
            }
            if (properties != null) {
                firstValue.assignPropsAndGroupingSet(properties, defaultGroupingSet);
            }
            if (useSuperAggregation) {
                firstValue.assignAggregators(aggs);
            }
            aggValues.add(firstValue);
            aggValues.addAll(prev.getMiddleAggValues());
            prevObject = prev.getEndingObject();
            prevAggsList = prev.getEndingAggList();
        }
        int aggListSize = prevAggsList.size();
        int listOfPalsSize = listOfPals.size();
        for (int i = 1; i < listOfPalsSize; ++i) {
            AggregateValue<T> prevValue;
            boolean objMatch;
            PositionedAggregatorList<T> curr = listOfPals.get(i);
            T currObject = curr.getInitialObject();
            List<Aggregator> currAggsList = curr.getInitialAggList();
            boolean bl = objMatch = comparator.compare(prevObject, currObject) == 0;
            if (curr.getEndingAggList() == null) {
                if (objMatch) {
                    for (int a = 0; a < aggListSize; ++a) {
                        Aggregator prevAgg = prevAggsList.get(a);
                        Aggregator currAgg = currAggsList.get(a);
                        prevAgg.merge(currAgg);
                        currAgg.setInUse(false);
                    }
                    continue;
                }
                AggregateValue<T> prevValue2 = new AggregateValue<T>(prevObject);
                for (int a = 0; a < aggListSize; ++a) {
                    Aggregator prevAgg = prevAggsList.get(a);
                    prevValue2.setAggregateValue(prevAgg, prevAgg.terminate());
                    if (useSuperAggregation) continue;
                    prevAgg.setInUse(false);
                }
                if (properties != null) {
                    prevValue2.assignPropsAndGroupingSet(properties, defaultGroupingSet);
                }
                if (useSuperAggregation) {
                    prevValue2.assignAggregators(prevAggsList);
                }
                aggValues.add(prevValue2);
                prevObject = currObject;
                prevAggsList = curr.getInitialAggList();
                continue;
            }
            if (objMatch) {
                prevValue = new AggregateValue<T>(prevObject);
                for (int a = 0; a < aggListSize; ++a) {
                    Aggregator prevAgg = prevAggsList.get(a);
                    Aggregator currAgg = currAggsList.get(a);
                    prevAgg.merge(currAgg);
                    currAgg.setInUse(false);
                    prevValue.setAggregateValue(prevAgg, prevAgg.terminate());
                    if (useSuperAggregation) continue;
                    prevAgg.setInUse(false);
                }
                if (properties != null) {
                    prevValue.assignPropsAndGroupingSet(properties, defaultGroupingSet);
                }
                if (useSuperAggregation) {
                    prevValue.assignAggregators(prevAggsList);
                }
                aggValues.add(prevValue);
            } else {
                prevValue = new AggregateValue<T>(prevObject);
                AggregateValue<T> currValue = new AggregateValue<T>(currObject);
                for (int a = 0; a < aggListSize; ++a) {
                    Aggregator prevAgg = prevAggsList.get(a);
                    prevValue.setAggregateValue(prevAgg, prevAgg.terminate());
                    Aggregator currAgg = currAggsList.get(a);
                    currValue.setAggregateValue(currAgg, currAgg.terminate());
                    if (properties != null) {
                        prevValue.assignPropsAndGroupingSet(properties, defaultGroupingSet);
                        currValue.assignPropsAndGroupingSet(properties, defaultGroupingSet);
                    }
                    if (useSuperAggregation) continue;
                    prevAgg.setInUse(false);
                    currAgg.setInUse(false);
                }
                if (useSuperAggregation) {
                    prevValue.assignAggregators(prevAggsList);
                    currValue.assignAggregators(currAggsList);
                }
                aggValues.add(prevValue);
                aggValues.add(currValue);
            }
            aggValues.addAll(curr.getMiddleAggValues());
            prevObject = curr.getEndingObject();
            prevAggsList = curr.getEndingAggList();
        }
        AggregateValue<T> prevValue = new AggregateValue<T>(prevObject);
        for (int a = 0; a < aggListSize; ++a) {
            Aggregator prevAgg = prevAggsList.get(a);
            prevValue.setAggregateValue(prevAgg, prevAgg.terminate());
            if (useSuperAggregation) continue;
            prevAgg.setInUse(false);
        }
        if (properties != null) {
            prevValue.assignPropsAndGroupingSet(properties, defaultGroupingSet);
        }
        if (useSuperAggregation) {
            prevValue.assignAggregators(prevAggsList);
        }
        aggValues.add(prevValue);
        return aggValues;
    }

    public static <T> int indexOfLastMatching(List<T> list, Comparator<? super T> comparator, int startIdx) {
        return Aggregations.indexOfLastMatching(list, comparator, startIdx, list.size() - 1);
    }

    public static <T> int indexOfLastMatching(List<T> list, Comparator<? super T> comparator, int startIdx, int maxIdx) {
        T value = list.get(startIdx);
        int addMatchIdx = 1;
        int lowerBoundMatchIdx = startIdx;
        int upperBoundMatchIdx = startIdx + addMatchIdx;
        while (true) {
            if (upperBoundMatchIdx >= maxIdx) {
                upperBoundMatchIdx = maxIdx;
                break;
            }
            if (comparator.compare(value, list.get(upperBoundMatchIdx)) != 0) break;
            lowerBoundMatchIdx = upperBoundMatchIdx;
            upperBoundMatchIdx += (addMatchIdx <<= 1);
        }
        while (true) {
            boolean downToTwo;
            int midMatchIdx = lowerBoundMatchIdx + upperBoundMatchIdx >> 1;
            if (lowerBoundMatchIdx == upperBoundMatchIdx) break;
            boolean bl = downToTwo = lowerBoundMatchIdx == upperBoundMatchIdx - 1;
            if (comparator.compare(value, list.get(midMatchIdx)) == 0) {
                if (downToTwo) {
                    if (comparator.compare(value, list.get(upperBoundMatchIdx)) != 0) break;
                    lowerBoundMatchIdx = upperBoundMatchIdx;
                    break;
                }
                lowerBoundMatchIdx = midMatchIdx;
                continue;
            }
            upperBoundMatchIdx = midMatchIdx - 1;
        }
        return lowerBoundMatchIdx;
    }
}

