/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;

public abstract class AbstractVarianceAggregator
extends Aggregator {
    protected long myCount;
    protected DoubleDouble mySum = new DoubleDouble();
    protected DoubleDouble myVarNumerator = new DoubleDouble();

    public AbstractVarianceAggregator(String property) {
        this.setProperty(property);
    }

    public void init() {
        this.myCount = 0L;
        this.mySum.reset();
        this.myVarNumerator.reset();
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)AbstractVarianceAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    long oldCount = this.myCount++;
                    double dVal = obj.doubleValue();
                    this.mySum.addToSelf(dVal);
                    if (this.myCount == 1L) {
                        this.myVarNumerator.reset();
                    } else {
                        DoubleDouble temp = new DoubleDouble(dVal);
                        temp.multiplySelfBy(this.myCount);
                        temp.subtractFromSelf(this.mySum);
                        temp.squareSelf();
                        temp.divideSelfBy(this.myCount);
                        temp.divideSelfBy(oldCount);
                        this.myVarNumerator.addToSelf(temp);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof AbstractVarianceAggregator) {
            AbstractVarianceAggregator otherAgg = (AbstractVarianceAggregator)agg;
            if (this.myCount == 0L) {
                this.myCount = otherAgg.myCount;
                this.mySum.addToSelf(otherAgg.mySum);
                this.myVarNumerator.addToSelf(otherAgg.myVarNumerator);
            } else if (otherAgg.myCount > 0L) {
                DoubleDouble temp = new DoubleDouble(otherAgg.myCount);
                temp.divideSelfBy(this.myCount);
                temp.multiplySelfBy(this.mySum);
                temp.subtractFromSelf(otherAgg.mySum);
                temp.squareSelf();
                DoubleDouble temp3 = new DoubleDouble(this.myCount);
                temp3.divideSelfBy(otherAgg.myCount * (this.myCount + otherAgg.myCount));
                temp3.multiplySelfBy(temp);
                this.myVarNumerator.addToSelf(otherAgg.myVarNumerator);
                this.myVarNumerator.addToSelf(temp3);
                this.mySum.addToSelf(otherAgg.mySum);
                this.myCount += otherAgg.myCount;
            }
        }
    }

    public abstract DoubleDouble terminateDoubleDouble();
}

