/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;
import net.sf.jagg.TwoPropAggregator;

public abstract class AbstractCovarianceAggregator
extends TwoPropAggregator {
    protected long myCount;
    protected DoubleDouble mySum1 = new DoubleDouble();
    protected DoubleDouble mySum2 = new DoubleDouble();
    protected DoubleDouble myVarNumerator = new DoubleDouble();

    public AbstractCovarianceAggregator(String properties) {
        this.setProperty(properties);
    }

    public AbstractCovarianceAggregator(String property, String property2) {
        this.setProperty(property + "," + property2);
    }

    public void init() {
        this.myCount = 0L;
        this.mySum1.reset();
        this.mySum2.reset();
        this.myVarNumerator.reset();
    }

    public void iterate(Object value) {
        if (value != null) {
            String property1 = this.getProperty();
            String property2 = this.getProperty2();
            try {
                Number obj1 = (Number)AbstractCovarianceAggregator.getValueFromProperty(value, property1);
                Number obj2 = (Number)AbstractCovarianceAggregator.getValueFromProperty(value, property2);
                if (obj1 != null && obj2 != null) {
                    long oldCount = this.myCount++;
                    double dVal1 = obj1.doubleValue();
                    double dVal2 = obj2.doubleValue();
                    this.mySum1.addToSelf(dVal1);
                    this.mySum2.addToSelf(dVal2);
                    if (this.myCount == 1L) {
                        this.myVarNumerator.reset();
                    } else {
                        DoubleDouble temp = new DoubleDouble(dVal1);
                        temp.multiplySelfBy(this.myCount);
                        temp.subtractFromSelf(this.mySum1);
                        DoubleDouble temp2 = new DoubleDouble(dVal2);
                        temp2.multiplySelfBy(this.myCount);
                        temp2.subtractFromSelf(this.mySum2);
                        temp.multiplySelfBy(temp2);
                        temp.divideSelfBy(this.myCount);
                        temp.divideSelfBy(oldCount);
                        this.myVarNumerator.addToSelf(temp);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property(ies) \"" + property1 + " and " + property2 + "\" must represent Numbers.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof AbstractCovarianceAggregator) {
            AbstractCovarianceAggregator otherAgg = (AbstractCovarianceAggregator)agg;
            if (this.myCount == 0L) {
                this.myCount = otherAgg.myCount;
                this.mySum1.addToSelf(otherAgg.mySum1);
                this.mySum2.addToSelf(otherAgg.mySum2);
                this.myVarNumerator.addToSelf(otherAgg.myVarNumerator);
            } else if (otherAgg.myCount > 0L) {
                DoubleDouble nOverM = new DoubleDouble(otherAgg.myCount);
                nOverM.divideSelfBy(this.myCount);
                DoubleDouble temp = new DoubleDouble(nOverM);
                temp.multiplySelfBy(this.mySum1);
                temp.subtractFromSelf(otherAgg.mySum1);
                DoubleDouble temp2 = new DoubleDouble(nOverM);
                temp2.multiplySelfBy(this.mySum2);
                temp2.subtractFromSelf(otherAgg.mySum2);
                temp.multiplySelfBy(temp2);
                DoubleDouble temp3 = new DoubleDouble(this.myCount);
                temp3.divideSelfBy(otherAgg.myCount * (this.myCount + otherAgg.myCount));
                temp3.multiplySelfBy(temp);
                this.myVarNumerator.addToSelf(otherAgg.myVarNumerator);
                this.myVarNumerator.addToSelf(temp3);
                this.mySum1.addToSelf(otherAgg.mySum1);
                this.mySum2.addToSelf(otherAgg.mySum2);
                this.myCount += otherAgg.myCount;
            }
        }
    }
}

