/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.MethodCache;
import net.sf.jagg.MethodCall;
import net.sf.jagg.msd.ChainedDiscriminator;
import net.sf.jagg.msd.ChainedExtractor;
import net.sf.jagg.msd.Discriminator;
import net.sf.jagg.msd.Discriminators;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.NullDiscriminator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDiscriminator<T>
extends ChainedDiscriminator<T> {
    private List<MethodCall> myMethodCalls;
    private String[] myProperties;

    public PropertiesDiscriminator(String ... properties) {
        this.myProperties = properties;
        int numProperties = this.myProperties.length;
        this.myMethodCalls = new ArrayList<MethodCall>(numProperties);
    }

    public PropertiesDiscriminator(List<String> properties) {
        this.myProperties = new String[properties.size()];
        if (!properties.isEmpty()) {
            properties.toArray(this.myProperties);
        }
        int numProperties = this.myProperties.length;
        this.myMethodCalls = new ArrayList<MethodCall>(numProperties);
    }

    @Override
    protected <E> ChainedExtractor<E, ?, T> getChainedExtractor(List<E> elements, Extractor<E, T> extractor) {
        T obj = extractor.getLabel(elements.get(0));
        MethodCache cache = MethodCache.getMethodCache();
        for (int i = 0; i < this.myProperties.length; ++i) {
            String property = this.myProperties[i];
            try {
                this.myMethodCalls.add(cache.getMethodCallFromProperty(obj, property));
                continue;
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException("Method or Property not found: " + e.getMessage(), e);
            }
        }
        return new MethodCallChainedExtractor(extractor);
    }

    @Override
    protected <E> Discriminator<?> getDiscriminator(List<E> elements, ChainedExtractor<E, ?, T> extractor, int index) {
        if (index < this.myProperties.length) {
            MethodCall mc = this.myMethodCalls.get(index);
            Class<?> returnType = mc.getReturnType();
            return Discriminators.getDiscriminator(returnType);
        }
        return new NullDiscriminator(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MethodCallChainedExtractor<E, L, B>
    extends ChainedExtractor<E, L, B> {
        public MethodCallChainedExtractor(Extractor<E, B> extractor) {
            super(extractor);
        }

        @Override
        public L getLabel(E element) {
            try {
                Object obj = this.myExtractor.getLabel(element);
                MethodCall mc = (MethodCall)PropertiesDiscriminator.this.myMethodCalls.get(this.myIndex);
                return (L)mc.invoke(obj);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException("Unable to access Method: " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedOperationException("Exception occurred in Method: " + e.getMessage(), e);
            }
        }

        @Override
        public boolean isComplete(E element) {
            return this.myExtractor.isComplete(element) || this.myIndex >= PropertiesDiscriminator.this.myProperties.length;
        }
    }
}

