/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.util.ArrayList;
import java.util.List;
import net.sf.jagg.msd.AbstractDiscriminator;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.MsdWorkspace;
import net.sf.jagg.msd.PortionExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortionDiscriminator<T>
extends AbstractDiscriminator<T> {
    private static final boolean DEBUG = false;

    @Override
    public <E> List<List<E>> discriminate(List<E> elements, Extractor<E, T> extractor, MsdWorkspace workspace) {
        int i;
        if (elements.size() == 0) {
            return new ArrayList<List<E>>(0);
        }
        ArrayList<List<E>> curr = new ArrayList<List<E>>(1);
        curr.add(elements);
        PortionExtractor<E, T> portionExtractor = this.getPortionExtractor(extractor);
        ArrayList<List<List<E>>> results = new ArrayList<List<List<E>>>();
        int index = 0;
        while (!curr.isEmpty()) {
            ArrayList<List<E>> next = new ArrayList<List<E>>();
            portionExtractor.setIndex(index);
            for (i = 0; i < curr.size(); ++i) {
                List currElements = (List)curr.get(i);
                List<List<E>> equivClasses = this.discriminatePortion(currElements, portionExtractor, workspace);
                if (equivClasses.size() == 1 && portionExtractor.isAllComplete()) {
                    results.add(equivClasses.get(0));
                    continue;
                }
                for (int j = 0; j < equivClasses.size(); ++j) {
                    List<E> equivClass = equivClasses.get(j);
                    if (equivClass.size() > 1) {
                        next.add(equivClass);
                        continue;
                    }
                    results.add(equivClass);
                }
            }
            curr = next;
            ++index;
        }
        int size = curr.size();
        for (i = 0; i < size; ++i) {
            results.add((List<List<E>>)curr.get(i));
        }
        return results;
    }

    protected <E> List<List<E>> discriminatePortion(List<E> elements, PortionExtractor<E, T> extractor, MsdWorkspace workspace) {
        int index;
        int usedSize = 0;
        int size = elements.size();
        ArrayList<E> completed = new ArrayList<E>();
        for (int i = 0; i < size; ++i) {
            E element = elements.get(i);
            if (extractor.isComplete(element)) {
                completed.add(element);
                continue;
            }
            index = extractor.getLabel(element);
            ArrayList<E> list = workspace.myLists[index];
            if (list == null) {
                workspace.myUsedIndexes[usedSize++] = index;
                workspace.myLists[index] = list = new ArrayList<E>();
            }
            list.add(element);
        }
        ArrayList<List<List>> result = new ArrayList<List<List>>(usedSize);
        if (!completed.isEmpty()) {
            result.add(completed);
        }
        extractor.setAllComplete(usedSize == 0);
        for (int i = 0; i < usedSize; ++i) {
            index = workspace.myUsedIndexes[i];
            result.add(workspace.myLists[index]);
            workspace.myLists[index] = null;
        }
        return result;
    }

    protected abstract <E> PortionExtractor<E, T> getPortionExtractor(Extractor<E, T> var1);
}

