/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg.msd;

import java.math.BigDecimal;
import net.sf.jagg.msd.Extractor;
import net.sf.jagg.msd.NumberDiscriminator;
import net.sf.jagg.msd.PortionExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalDiscriminator
extends NumberDiscriminator<BigDecimal> {
    @Override
    protected <E> PortionExtractor<E, BigDecimal> getPortionExtractor(Extractor<E, BigDecimal> e) {
        return new PortionExtractor<E, BigDecimal>(e){

            @Override
            public int getLabel(E element) {
                BigDecimal bd = ((BigDecimal)this.myExtractor.getLabel(element)).stripTrailingZeros();
                if (this.myIndex < 2) {
                    int scalePortion = bd.scale();
                    return (scalePortion >>= (1 - this.myIndex) * 16) & 0xFFFF;
                }
                return bd.unscaledValue().toByteArray()[this.myIndex - 2] & 0xFFFF;
            }

            @Override
            public boolean isComplete(E element) {
                return this.myExtractor.isComplete(element) || this.myIndex >= ((BigDecimal)this.myExtractor.getLabel(element)).stripTrailingZeros().unscaledValue().toByteArray().length + 2;
            }
        };
    }
}

