/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;

public class MinAggregator
extends Aggregator {
    private Comparable myMin;

    public MinAggregator(String property) {
        this.setProperty(property);
    }

    public MinAggregator replicate() {
        return new MinAggregator(this.getProperty());
    }

    public void init() {
        this.myMin = null;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Comparable obj = (Comparable)MinAggregator.getValueFromProperty(value, property);
                if (obj != null && (this.myMin == null || obj.compareTo(this.myMin) < 0)) {
                    this.myMin = obj;
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must be Comparable.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof MinAggregator) {
            MinAggregator otherAgg = (MinAggregator)agg;
            if (otherAgg.myMin.compareTo(this.myMin) < 0) {
                this.myMin = otherAgg.myMin;
            }
        }
    }

    public Comparable terminate() {
        return this.myMin;
    }
}

