/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;

public class GeometricMeanAggregator
extends Aggregator {
    private double myProduct;
    private long myCount;

    public GeometricMeanAggregator(String property) {
        this.setProperty(property);
    }

    public GeometricMeanAggregator replicate() {
        return new GeometricMeanAggregator(this.getProperty());
    }

    public void init() {
        this.myProduct = 1.0;
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)GeometricMeanAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                    this.myProduct *= obj.doubleValue();
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof GeometricMeanAggregator) {
            GeometricMeanAggregator otherAgg = (GeometricMeanAggregator)agg;
            this.myProduct *= otherAgg.myProduct;
            this.myCount += otherAgg.myCount;
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        if (this.myCount > 0L) {
            DoubleDouble result = new DoubleDouble(this.myProduct);
            result.nthRootSelf(this.myCount);
            return result;
        }
        return new DoubleDouble(DoubleDouble.NaN);
    }
}

