/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;

public class ConcatAggregator
extends Aggregator {
    private StringBuilder myBuf;
    private String mySeparator;
    private boolean hasContent;

    public ConcatAggregator(String property) {
        this(property, "");
    }

    public ConcatAggregator(String property, String separator) {
        this.setProperty(property);
        this.mySeparator = separator;
    }

    public ConcatAggregator replicate() {
        return new ConcatAggregator(this.getProperty(), this.mySeparator);
    }

    protected void setProperty(String property) {
        String[] fields = property.split(",", 2);
        if (fields.length == 1) {
            super.setProperty(property);
            this.mySeparator = "";
        } else if (fields.length >= 2) {
            super.setProperty(fields[0]);
            String sepExpression = fields[1].trim();
            if (sepExpression.startsWith("\"") && sepExpression.endsWith("\"")) {
                sepExpression = sepExpression.length() == 1 ? "\"" : sepExpression.substring(1, sepExpression.length() - 1);
            }
            this.mySeparator = sepExpression;
        }
    }

    public void init() {
        this.myBuf = new StringBuilder();
        this.hasContent = false;
    }

    public void iterate(Object value) {
        String property;
        Object obj;
        if (value != null && (obj = ConcatAggregator.getValueFromProperty(value, property = this.getProperty())) != null) {
            if (this.hasContent && this.mySeparator != null && this.mySeparator.length() > 0) {
                this.myBuf.append(this.mySeparator);
            } else {
                this.hasContent = true;
            }
            this.myBuf.append(obj.toString());
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof ConcatAggregator) {
            ConcatAggregator otherAgg = (ConcatAggregator)agg;
            if (otherAgg.hasContent) {
                if (!this.hasContent) {
                    this.hasContent = true;
                } else {
                    this.myBuf.append(this.mySeparator);
                }
                this.myBuf.append((CharSequence)otherAgg.myBuf);
            }
        }
    }

    public String terminate() {
        return this.myBuf.toString();
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getProperty() + (this.mySeparator.length() > 0 ? ",\"" + this.mySeparator + "\"" : "") + ")";
    }
}

