/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jagg;

import net.sf.jagg.Aggregator;
import net.sf.jagg.DoubleDouble;

public class AvgAggregator
extends Aggregator {
    private DoubleDouble mySum = new DoubleDouble();
    private long myCount;

    public AvgAggregator(String property) {
        this.setProperty(property);
    }

    public AvgAggregator replicate() {
        return new AvgAggregator(this.getProperty());
    }

    public void init() {
        this.mySum.reset();
        this.myCount = 0L;
    }

    public void iterate(Object value) {
        if (value != null) {
            String property = this.getProperty();
            try {
                Number obj = (Number)AvgAggregator.getValueFromProperty(value, property);
                if (obj != null) {
                    ++this.myCount;
                    this.mySum.addToSelf(obj.doubleValue());
                }
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Property \"" + property + "\" must represent a Number.", e);
            }
        }
    }

    public void merge(Aggregator agg) {
        if (agg != null && agg instanceof AvgAggregator) {
            AvgAggregator otherAgg = (AvgAggregator)agg;
            this.mySum.addToSelf(otherAgg.mySum);
            this.myCount += otherAgg.myCount;
        }
    }

    public Double terminate() {
        return this.terminateDoubleDouble().doubleValue();
    }

    public DoubleDouble terminateDoubleDouble() {
        if (this.myCount > 0L) {
            DoubleDouble result = new DoubleDouble(this.mySum);
            result.divideSelfBy(this.myCount);
            return result;
        }
        return DoubleDouble.NaN;
    }
}

